import { Component } from '@angular/core';
import { FormsModule, NgForm } from '@angular/forms';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { ActivatedRoute, Router, RouterLink } from '@angular/router';
import { TranslatePipe } from '@ngx-translate/core';
import { CookieService } from 'ngx-cookie-service';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';

import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { NgbAlertModule } from '@ng-bootstrap/ng-bootstrap';
import { SharedModule } from '../../../../shared/shared.module';
import { CommonModule } from '@angular/common';
import { AnnouncementHolidayBannerComponent } from '../../../../shared/common/includes/announcement-holiday-banner/announcement-holiday-banner.component';


@Component({
  selector: 'app-admingoogle2fa',
  templateUrl: './admingoogle2fa.component.html',
  styleUrls: ['./admingoogle2fa.component.scss'],
  standalone: true,
  imports: [CommonModule, FormsModule, NgbAlertModule, TranslatePipes, RouterLink, AnnouncementHolidayBannerComponent],
  providers : [TranslatePipes]
})
export class Admingoogle2faComponent extends Unsub {
  email;
  data;
  redireurl;
  hideAlertsUntil: { [key: string]: number } = {};
  public sendingResponse: { [key: string]: boolean } = {};
  // otpverify

  constructor(private adminService: AdminService, loaderService: LoaderService,
    private cookieService: CookieService,
    private sanitizer: DomSanitizer,private router: Router, private toastr: ToastrService, private translate: TranslatePipe, private activeRouter: ActivatedRoute) {
    super(loaderService);
    this.redireurl = this.activeRouter.snapshot.queryParams['returnUrl'];
    this.activeRouter.paramMap
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (params) => {
          this.email = params.get('id');
          this.adminService.adminindexlogin(this.email).subscribe(res => {
            this.data = res
            if (res.success) {
              let url = this.redireurl ? this.redireurl : '/admin/dashboard'
              this.router.navigate([url]);
            }
            if (res) {
              res.announcement?.forEach(alert => {
                const hideAlertsUntil = this.cookieService.get('anct' + alert.id);
                if (hideAlertsUntil) {
                  this.hideAlertsUntil['anct' + alert.id] = parseInt(hideAlertsUntil, 10);
                }
              })
              res.announcements?.forEach(alert => {
                const hideAlertsUntil = this.cookieService.get('anct' + alert.id);
                if (hideAlertsUntil) {
                  this.hideAlertsUntil['anct' + alert.id] = parseInt(hideAlertsUntil, 10);
                }
              })
              res.holidays?.forEach(alert => {
                const hideAlertsUntil = this.cookieService.get('holiday' + alert.id);
                if (hideAlertsUntil) {
                  this.hideAlertsUntil['holiday' + alert.id] = parseInt(hideAlertsUntil, 10);
                }
              })
            }
          });
        }
      })
  }
  admingoogle2FaFn(ngform: NgForm, buttonId) {
    if(!ngform.value.one_time_password){
      this.toastr.error(this.translate.transform("OTP is required"));
      return;
    }
    let data = {
      email: this.email,
      one_time_password: ngform.value.one_time_password
    };
    this.sendingResponse[buttonId] = true;
    this.adminService.admingoogle2faotpverify(data)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.sendingResponse[buttonId] = false;
          if (res?.success) {
            this.toastr.success(this.translate.transform(res.success));
            let url = this.redireurl ? this.redireurl : '/admin/dashboard'
            this.router.navigate([url]);
          }
          if (res?.error) {
            this.toastr.error(this.translate.transform(res.error));
          }
        },
        error: () => {
          this.sendingResponse[buttonId] = false;
        },
      });
  }

}
