import { Component, ViewChild } from '@angular/core';
import { FormBuilder, FormGroup, FormsModule } from '@angular/forms';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { MatTableDataSource } from '@angular/material/table';
import { NgbModal, NgbDateParserFormatter, NgbTooltipModule } from '@ng-bootstrap/ng-bootstrap';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil} from 'rxjs';
import { Unsub } from '../../../shared/class/unsub.class';
import { AdminService } from '../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../shared/services/loader.service';
import { TranslationService } from '../../../shared/services/translation.service';
import { CommonModule } from '@angular/common';
import { MaterialeModules } from '../../../material.module';
import { RouterLink } from '@angular/router';
import { AdminPageHeaderComponent } from '../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { TranslatePipes } from '../../../shared/pipes/translate/translate.pipe';

@Component({
  selector: 'app-addons',
  templateUrl: './addons.component.html',
  styleUrls: ['./addons.component.scss'],  
  standalone: true,
  imports : [CommonModule, AdminPageHeaderComponent, TranslatePipes, MaterialeModules, NgbTooltipModule, FormsModule, RouterLink ]

})
export class AddonsComponent extends Unsub {

  public sendingResponse: { [key: string]: boolean } = {};
  displayedColumns: string[] = [
    'sno',
    'addonType',
    'name',
    'icon',
    'version',
    'status',
    'lastupdated',
    'actions',
  ];
  dataSource!: MatTableDataSource<any>;
  permission: any;
  adddonslist: any;
  isloader = true;
  @ViewChild(MatPaginator) paginator!: MatPaginator;
  @ViewChild(MatSort) sort!: MatSort;

  addonForm: FormGroup;
  constructor(
    private adminService: AdminService,
    private toastr: ToastrService,
    private modalService: NgbModal,
    public formatter: NgbDateParserFormatter,
    private translate: TranslatePipe,
    private translationService: TranslationService,
    private fb: FormBuilder,
    loaderService: LoaderService,
  ) {
    /**
* This code calls the constructor of the parent class in a subclass. 
* The super() function is used to initialize the parent class and allows access to its properties and methods. 
* By calling  super(), the subclass can inherit and use the functionality of the parent class.
**/
    super(loaderService);
    this.translationService.TranslationStatus.subscribe(() => {
      setTimeout(() => {
        this.paginator._intl.itemsPerPageLabel = this.translate.transform('items per page:');
        this.paginator._intl.nextPageLabel = this.translate.transform('next');
        this.paginator._intl.previousPageLabel = this.translate.transform('previous');
        this.paginator._intl.firstPageLabel = this.translate.transform('first page');
        this.paginator._intl.lastPageLabel = this.translate.transform('last page');
        const of = this.translate.transform('of');
        this.paginator._intl.getRangeLabel = (page: number, pageSize: number, length: number) => {
          if (length == 0 || pageSize == 0) return `0 ${of} ${length}`;
          length = Math.max(length, 0);
          const startIndex = page * pageSize;
          const endIndex = startIndex < length ? Math.min(startIndex + pageSize, length) : startIndex + pageSize;

          return `${startIndex + 1} - ${endIndex} ${of} ${length}`;
        };
      }, 100);
    });
    this.translationService.setTranslationaStatus(true);
    
    this.addonForm = this.fb.group({
      addon: null,
    });
  }

  ngOnInit(): void {

    this.addonsList();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        this.addonsList();
      },
    });
  }
  addonsList() {
    this.isloader = true;
    this.loaderService.showLoader();
    this.adminService
      .addons()
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.permission = res.permissions;
          this.adddonslist = res.addons;
          // Assign the data to the data source for the table to render
          this.isloader = false;
          this.dataSource = new MatTableDataSource(this.adddonslist);

          this.loaderService.hideLoader();
        },
        error: () => {
          this.isloader = true;
          this.loaderService.hideLoader()
        }
      });

  }
  // this is needed to allow sorting on nested properties
  nestedProperty = (data: any, sortHeaderId: string): string | number => {
    return sortHeaderId
      ?.split('.')
      .reduce((accumulator, key) => accumulator && accumulator[key], data) as
      | string
      | number;
  };
  // this is needed to have caseInsensitive sorting
  caseInsensitive = (data: any, sortHeaderId: string): string | number => {
    const value = data[sortHeaderId];
    return typeof value === 'string' ? value.toUpperCase() :
      value;
  };
  nestedCaseInsensitive = (data: any, sortHeaderId: string): string | number => {
    const value = sortHeaderId
      ?.split('.')
      .reduce((accumulator, key) => accumulator && accumulator[key], data) as
      | string
      | number;
    return typeof value === 'string' ? value.toUpperCase() : value;
  };

  addonsStatusChange(event, row, buttonId) {
    const val = event.checked ? '1' : '0';
    this.sendingResponse[buttonId] = true;
    
    const formData: any = new FormData();
    formData.append('status', val);
    
    this.adminService
        .addonsStatuschange(row?.id, formData)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
            next: (res) => {
                this.sendingResponse[buttonId] = false;
                if (res?.success) {
                    this.toastr.success(this.translate.transform(res.success));
                }
                if (res?.error) {
                    this.toastr.error(this.translate.transform(res.error));
                }
            },
            error: () => {
                this.sendingResponse[buttonId] = false;
            },
        });
  }
  applicationLicencekeyStatus =false;
  applicationLicencekey;
  addonLicencekeyStatus=false;
  addonLicencekey;
  addonEle=false;
  zipFileEle=false;


  addZipFile(event: any) {
    // this.File = event.target.files[0].name
    const file = (event.target as HTMLInputElement)?.files?.[0];
    this.addonForm.patchValue({
      addon: file,
    });
  }
  addonsApplicationEnavatoVerifyApplicationPurchaseCode(event, buttonId) {

    this.sendingResponse[buttonId] = true;
    if (event.value?.trim().length == 36) {
      const data = {
        data: event.value,
        item: "application"
      };
      this.adminService.addonsApplicationEnavatoVerify(data).subscribe({
        next: res => {
          this.sendingResponse[buttonId] = false;
          if (res.success && res.valid) {
            this.toastr.success(this.translate.transform(res.success));
            this.applicationLicencekey = res.key;
            this.applicationLicencekeyStatus = true;
            this.addonEle = true;
          }
          if (res.error && !res.valid) {
            this.toastr.error(this.translate.transform(res.error));
            this.applicationLicencekey = '';
            this.applicationLicencekeyStatus = false;
            this.addonEle = false;
            this.addonLicencekey = '';
            this.addonLicencekeyStatus = false;
            this.zipFileEle = false;
          }
        },
        error : err => this.sendingResponse[buttonId] = false
      })
    }
  }
  addonsApplicationEnavatoVerifyAddonPurchaseCode(event, buttonId) {

    this.sendingResponse[buttonId] = true;
    if (event.value?.trim().length == 36) {
      const data = {
        data: event.value,
        item: "addon"
      };
      this.adminService.addonsApplicationEnavatoVerify(data).subscribe({
        next: res => {
          this.sendingResponse[buttonId] = false;
          if (res.success && res.valid) {
            this.toastr.success(this.translate.transform(res.success));
            this.addonLicencekey = res.key;
            this.addonLicencekeyStatus = true;
            this.zipFileEle = true;
          }
          if (res.error && !res.valid) {
            this.toastr.error(this.translate.transform(res.error));
            this.addonLicencekey = '';
            this.addonLicencekeyStatus = false;
            this.zipFileEle = false;
          }
        },
        error : err => this.sendingResponse[buttonId] = false
      })
    }
  }

  addonDetails(content) {
    const modalRef = this.modalService.open(content, {
      size: 'lg',
      backdrop: 'static', keyboard: false
    });
    modalRef.result.then(
      () => {
        this.applicationLicencekeyStatus =false;
        this.applicationLicencekey = '';
        this.addonLicencekeyStatus=false;
        this.addonLicencekey = '';
        this.addonEle=false;
        this.zipFileEle=false;
      },
      () => {
        this.applicationLicencekeyStatus =false;
        this.applicationLicencekey = '';
        this.addonLicencekeyStatus=false;
        this.addonLicencekey = '';
        this.addonEle=false;
        this.zipFileEle=false;
      }
    );
  }
  credentials;
  editAddonDetails(content, row) {

    this.adminService.addonsEdit(row.id).subscribe({
      next : res=>{
        this.credentials = res;
      }
    })

    const modalRef = this.modalService.open(content, {
      size: 'lg',
      backdrop: 'static', keyboard: false
    });
    modalRef.result.then(
      () => {
        this.credentials = {}
      },
      () => {
        this.credentials = {}
      }
    );
  }
  createAddon(ngForm, FileUploadloader, buttonId) {

    if (ngForm.valid && this.applicationLicencekeyStatus && this.addonLicencekeyStatus) {
      this.sendingResponse[buttonId] = true;
      FileUploadloader.classList.remove('d-none');
      
      const formData: any = new FormData();
      
      formData.append('applicationPurchasecode', this.applicationLicencekey);
      formData.append('purchasecode', this.addonLicencekey);
      formData.append('addon', this.addonForm.controls['addon'].value);
      
      this.adminService.storeAddons(formData).subscribe({
        next: res=>{
          this.sendingResponse[buttonId] = false;
          if(res?.success){
            this.toastr.success(this.translate.transform(res.success));
            this.modalService.dismissAll()
          }
          if(res?.error){
            this.toastr.error(this.translate.transform(res.error));
          }
        },
        error : err => {
          this.sendingResponse[buttonId] = false;
          FileUploadloader.classList.add('d-none');
        }
      })
    }
  }
  editAddon(ngForm, buttonId) {
    if(ngForm.valid){
      this.sendingResponse[buttonId] = true;
      
      const formData: any = new FormData();
      for (const key of Object.keys(ngForm.value)) {
        formData.append(key, ngForm.value[key]);
      }
      formData.append('addonid', this.credentials[2]);
      // let data = ngForm.value;
      // data['addonid'] = this.credentials[2];
      this.adminService.addonsCredentials(formData).subscribe({
        next : res=> {
          this.sendingResponse[buttonId] = false;
          if(res?.success){
            this.toastr.success(this.translate.transform(res.success));
            this.modalService.dismissAll()
          }
          if(res?.error){
            this.toastr.error(this.translate.transform(res.error));
          }
        },
        error : err => {
          this.sendingResponse[buttonId] = false;
        }
      })
    }
  }
}
