import { SelectionModel } from '@angular/cdk/collections';
import {
    Component,
    ElementRef,
    OnInit,
    QueryList,
    ViewChild,
    ViewChildren,
} from '@angular/core';
import { FormsModule, NgForm } from '@angular/forms';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { MatTableDataSource } from '@angular/material/table';
import {
    NgbDate,
    NgbDateParserFormatter,
    NgbDatepickerModule,
    NgbModal,
    NgbTooltipModule,
} from '@ng-bootstrap/ng-bootstrap';
import { ToastrService } from 'ngx-toastr';
import { Observable, Subject, debounceTime, distinctUntilChanged, switchMap, takeUntil, tap } from 'rxjs';


import Swal from 'sweetalert2';
import { TranslatePipe } from '@ngx-translate/core';
import { Unsub } from '../../../shared/class/unsub.class';
import { adminToolbar } from '../../../shared/data/editortoolbar';
import { AdminService } from '../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../shared/services/loader.service';
import { TranslationService } from '../../../shared/services/translation.service';
import { AngularEditorConfig, AngularEditorModule } from '@kolkov/angular-editor';
import { CommonModule } from '@angular/common';
import { MaterialeModules } from '../../../material.module';
import { ColorPickerModule } from 'ngx-color-picker';
import { NgSelectModule } from '@ng-select/ng-select';
import { TranslatePipes } from '../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../shared/common/pageheader/admin-page-header/admin-page-header.component';

@Component({
    selector: 'app-announcements',
    templateUrl: './announcements.component.html',
    styleUrls: ['./announcements.component.scss'],
    standalone : true,
    imports : [CommonModule, AdminPageHeaderComponent, TranslatePipes, MaterialeModules, NgbTooltipModule, ColorPickerModule, NgSelectModule, NgbDatepickerModule, AngularEditorModule, FormsModule ]
})
export class AnnouncementsComponent extends Unsub implements OnInit {
   
    public primaryColorToggle: boolean = false;
    private searchTerms = new Subject<string>();
    public secondaryColorToggle: boolean = false;
    public allAnnouncements: any;
    setting;
    currrentDate = { year: 0, month: 0, day: 0 };
    today!: Date;
    public assignedMem: any = [];
    public ticketDetails: any;
    public userDetails: any;
    public refreshToken$: any;
    public sendingResponse: { [key: string]: boolean } = {};
    toolbar: AngularEditorConfig = adminToolbar;
    normalDay: any[] = [
        { id: 1, value: 'Mon' },
        { id: 2, value: 'Tue' },
        { id: 3, value: 'Wed' },
        { id: 4, value: 'Thu' },
        { id: 5, value: 'Fri' },
        { id: 6, value: 'Sat' },
        { id: 7, value: 'Sun' },
    ];
    displayedColumns: string[] = [
        'sno',
        'select',
        'title',
        'startdate',
        'enddate',
        'selectedday',
        'status',
        'actions',
    ];
    dataSource!: MatTableDataSource<any>;
    selection = new SelectionModel<any>(true, []);
    permission: any;
    isloader = true;
    @ViewChild(MatPaginator) paginator!: MatPaginator;
    @ViewChild(MatSort) sort!: MatSort;
    minFromDate!: { year: number; month: number; day: number; };

    constructor(
        private adminService: AdminService,
        private toastr: ToastrService,
        private modalService: NgbModal,
        public formatter: NgbDateParserFormatter,
        private translate: TranslatePipe,
        private translationService: TranslationService,
        loaderService: LoaderService,
    ) {
        /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
        super(loaderService);
        this.translationService.TranslationStatus.subscribe(() => {
            setTimeout(() => {
                this.paginator._intl.itemsPerPageLabel = this.translate.transform('items per page:');
                this.paginator._intl.nextPageLabel = this.translate.transform('next');
                this.paginator._intl.previousPageLabel = this.translate.transform('previous');
                this.paginator._intl.firstPageLabel = this.translate.transform('first page');
                this.paginator._intl.lastPageLabel = this.translate.transform('last page');
                const of = this.translate.transform('of');
                this.paginator._intl.getRangeLabel = (page: number, pageSize: number, length: number) => {
                    if (length == 0 || pageSize == 0) return `0 ${of} ${length}`;
                    length = Math.max(length, 0);
                    const startIndex = page * pageSize;
                    const endIndex = startIndex < length ? Math.min(startIndex + pageSize, length) : startIndex + pageSize;

                    return `${startIndex + 1} - ${endIndex} ${of} ${length}`;
                };
            }, 100);
        });
        this.translationService.setTranslationaStatus(true);
        this.toolbar.placeholder = this.translate.transform('Enter Your Text...');
    }

    ngOnInit(): void {
        this.today = new Date();
        this.currrentDate = { year: this.today.getFullYear(), month: this.today.getMonth() + 1, day: this.today.getDate() };
        this.announcementList();
        this.adminService.RefreshRquestAdmin$.pipe(
            takeUntil(this.unSubscribe$)
        ).subscribe({
            next: () => {
                this.announcementList();
            },
        });
        this.searchTerms.pipe(
            debounceTime(300),
            distinctUntilChanged(),
            switchMap((): any => this.loadData())
        ).subscribe();
    }
    announcementList() {
        this.isloader = true;
        this.loaderService.showLoader();
        this.adminService
            .announcement(1, 10, this.filterValue)
            .pipe(takeUntil(this.unSubscribe$))
            .subscribe({
                next: (res) => {
                    this.permission = res.permissions;
                    this.allAnnouncements = res.queryList;
                    this.setting = res.setting?.original;
                    // Assign the data to the data source for the table to render
                    this.isloader = false;
                    this.dataSource = new MatTableDataSource(this.allAnnouncements.data);

                    if (this.dataSource) {
                        this.paginator.pageSize = this.allAnnouncements.per_page;
                        setTimeout(() => {
                            this.paginator.pageIndex = this.allAnnouncements.current_page - 1;
                            this.paginator.length = this.allAnnouncements.total;
                        });
                        this.dataSource.paginator = this.paginator;

                        // this.sort.disableClear = true; // Used to disbale the original soting of data if enabled (Only ASC, DES).
                        this.dataSource.sort = this.sort;
                        this.dataSource.sortingDataAccessor = (data, sortHeaderId) => {
                            switch (sortHeaderId) {
                                case 'user':
                                case 'ticketdetails':
                                case 'status':
                                    return this.nestedProperty(data, sortHeaderId);
                                default:
                                    return this.nestedCaseInsensitive(data, sortHeaderId);
                            }
                        }
                    }
                    if (!this.permission?.includes('Announcements Delete')) {
                        this.displayedColumns = [
                            'sno',
                            'title',
                            'startdate',
                            'enddate',
                            'status',
                            'actions',
                        ];
                    }
                    this.loaderService.hideLoader();
                },
                error: () => {
                    this.isloader = true;
                    this.loaderService.hideLoader()
                }
            });

    }

    filterValue = "";
    applyFilter(event: Event) {
        this.filterValue = (event.target as HTMLInputElement).value;
        this.searchTerms.next(this.filterValue);
    }

    /** Whether the number of selected elements matches the total number of rows. */
    isAllSelected() {
        const numSelected = this.selection.selected.length;
        let numRows;
        if (this.dataSource) {
            numRows = this.dataSource.data.length;
        }
        return numSelected === numRows;
    }
    /** Selects all rows if they are not all selected; otherwise clear selection. */
    toggleAllRows() {
        if (this.isAllSelected()) {
            this.selection.clear();
            return;
        }
        this.selection.select(...this.dataSource.data);
    }

    /** The label for the checkbox on the passed row */
    checkboxLabel(row?: any): string {
        if (!row) {
            return `${this.isAllSelected() ? 'deselect' : 'select'} all`;
        }
        return `${this.selection.isSelected(row) ? 'deselect' : 'select'} row ${row?.id + 1
            }`;
    }
    createAnnouncementModel(createAnnouncement) {
        const modalRef = this.modalService.open(createAnnouncement, {
            size: 'lg',
            backdrop: 'static', keyboard: false
        });
        modalRef.result.then(
            () => {
                this.fromDate = null;
                this.toDate = null;
                this.announcementObj['secondary_color'] = ""
                this.announcementObj['primary_color'] = ""
            },
            () => {
                this.fromDate = null;
                this.toDate = null;
                this.announcementObj['secondary_color'] = ""
                this.announcementObj['primary_color'] = ""
            }
        );
    }
    editAnnouncementDetails(editannouncement, row) {
        this.fromDate = this.formatter.parse(row?.startdate);
        this.toDate = this.formatter.parse(row?.enddate);

        this.announcementObj = {
            "testimonialId": row?.id,
            "title": row?.title,
            "notice": row?.notice,
            "buttonurl": row?.buttonurl,
            "buttonlable": row?.buttonlable,
            "status": row?.status,
            "primary_color": row?.primary_color,
            "secondary_color": row?.secondary_color,
            "announcementday": row.announcementday?.split(','),
        };

        const modalRef = this.modalService.open(editannouncement, {
            size: 'lg', backdrop: 'static', keyboard: false
        });
        modalRef.result.then(
            () => {
                this.fromDate = null;
                this.toDate = null;
                this.announcementObj = {
                    "testimonialId": '',
                    "title": '',
                    "notice": '',
                    "buttonlable": '',
                    "buttonurl": '',
                    "status": '',
                    "announcementday": '',
                    "primary_color": '',
                    "secondary_color": '',
                };
            },
            () => {
                this.fromDate = null;
                this.toDate = null;
                this.announcementObj = {
                    "testimonialId": '',
                    "title": '',
                    "notice": '',
                    "status": '',
                    "buttonlable": '',
                    "buttonurl": '',
                    "announcementday": '',
                    "primary_color": '',
                    "secondary_color": '',
                };
            }
        );
    }
    announcementObj: any = {
        "testimonialId": '',
        "title": '',
        "notice": '',
        "buttonlable": '',
        "buttonurl": '',
        'startdate': '',
        "enddate": '',
        "status": '',
        "primary_color": '',
        "secondary_color": '',
        "announcementday": [],
    };

    createannouncement(ngForm: NgForm, buttonId) {

        if (ngForm.valid) {
            this.sendingResponse[buttonId] = true;
            const data = ngForm.value;
            if (ngForm.value.startdate) {
                data['startdate'] = this.formatter.format(ngForm.value.startdate);
            }
            if (ngForm.value.enddate) {
                data['enddate'] = this.formatter.format(ngForm.value.enddate);
            }
            if (ngForm.value.announcementday?.length) {
                data['announcementday'] = ngForm.value.announcementday;
            }
            this.adminService
                .createAnnouncement(data)
                .pipe(takeUntil(this.unSubscribe$))
                .subscribe({
                    next: (res) => {
                        this.sendingResponse[buttonId] = false;
                        if (res?.success) {
                            this.toastr.success(this.translate.transform(res.success));
                            this.modalService.dismissAll();
                        }
                    },
                    error: () => {
                        this.sendingResponse[buttonId] = false;
                    },
                });
        }
    }
    editannouncement(ngForm: NgForm, buttonId) {
        if (ngForm.valid) {
            this.sendingResponse[buttonId] = true;

            const data = ngForm.value;
            if (ngForm.value.startdate) {
                data['startdate'] = this.formatter.format(ngForm.value.startdate);
            }
            if (ngForm.value.enddate) {
                data['enddate'] = this.formatter.format(ngForm.value.enddate);
            }
            if (ngForm.value.announcementday?.length) {
                data['announcementday'] = ngForm.value.announcementday;
            }
            data['testimonialId'] = this.announcementObj.testimonialId;

            this.adminService
                .updateAnnouncement(data)
                .pipe(takeUntil(this.unSubscribe$))
                .subscribe({
                    next: (res) => {
                        this.sendingResponse[buttonId] = false;
                        if (res?.success) {
                            this.toastr.success(this.translate.transform(res.success));
                            this.modalService.dismissAll();
                        }
                    },
                    error: () => {
                        this.sendingResponse[buttonId] = false;
                    },
                });
        }
    }
    announcementStatusChange(event, row, buttonId) {
        const val = event.checked ? '1' : '0';
        this.sendingResponse[buttonId] = true;
        const data = {

            id: row?.id,
            status: val,
        };
        this.adminService
            .statusAnnouncement(row?.id, data)
            .pipe(takeUntil(this.unSubscribe$))
            .subscribe({
                next: (res) => {
                    this.sendingResponse[buttonId] = false;
                    if (res?.success) {
                        this.toastr.success(this.translate.transform(res.success));
                    }
                },
                error: () => {
                    this.sendingResponse[buttonId] = false;
                },
            });
    }

    deleteAnnouncement(row: any, buttonId) {
        const data = {

        };

        Swal.fire({
            icon: 'warning',
            title: this.translate.transform('Are you sure ?'),
            text: this.translate.transform('Your will not be able to recover!'),
            showCancelButton: true,
            confirmButtonColor: '#6259ca',
            cancelButtonColor: '#f11541',
            confirmButtonText: this.translate.transform('Yes, delete it!'),
            cancelButtonText: this.translate.transform('Close'),
            reverseButtons: true,
        }).then((result: any) => {
            if (result.isConfirmed) {
                this.sendingResponse[buttonId] = true;
                this.adminService
                    .deleteAnnouncement(row?.id, data)
                    .pipe(takeUntil(this.unSubscribe$))
                    .subscribe({
                        next: (res) => {
                            this.sendingResponse[buttonId] = false;
                            if (res?.success) {
                                this.toastr.success(this.translate.transform(res.success));
                            }
                        },
                        error: () => {
                            this.sendingResponse[buttonId] = false;
                        },
                    });
            }
        });
    }
    massDeleteAnnouncements(buttonId) {
        if (!this.selection.selected?.length) {
            this.toastr.error(this.translate.transform('Please select atleast one Announcement'));
            return;
        }
        const id: any = [];
        this.selection.selected.map(function (ele) {
            id.push(ele.id);
        });
        const data = {

            id: id,
        };

        Swal.fire({
            icon: 'warning',
            title: this.translate.transform('Are you sure ?'),
            text: this.translate.transform('Your will not be able to recover!'),
            showCancelButton: true,
            confirmButtonColor: '#6259ca',
            cancelButtonColor: '#f11541',
            confirmButtonText: this.translate.transform('Yes, delete it!'),
            cancelButtonText: this.translate.transform('Close'),
            reverseButtons: true,
        }).then((result: any) => {
            if (result.isConfirmed) {
                this.sendingResponse[buttonId] = true;
                this.adminService
                    .massdeleteAnnouncement(data)
                    .pipe(takeUntil(this.unSubscribe$))
                    .subscribe({
                        next: (res) => {
                            this.sendingResponse[buttonId] = false;
                            this.selection.clear();
                            if (res.success) {
                                this.toastr.success(this.translate.transform(res.success));
                            }
                        },
                        error: () => {
                            this.sendingResponse[buttonId] = false;
                        },
                    });
            }
        });
    }
    announcementsetting(ngForm, buttonId) {
        if (ngForm.valid) {
            this.sendingResponse[buttonId] = true;
            const data = ngForm.value;
            this.adminService.announcementsetting(data).subscribe({
                next: (res) => {
                    this.sendingResponse[buttonId] = false;
                    if (res?.success) {
                        this.toastr.success(this.translate.transform(res.success));
                    }
                    if (res?.error) {
                        this.toastr.error(this.translate.transform(res.error));
                    }
                },
                error: () => {
                    this.sendingResponse[buttonId] = false;
                },
            });
        }
    }

    changedAnnouncementDay() {
        this.fromDate = null;
        this.toDate = null;
    }
    changedAnnouncementinput(daycontainer) {
        daycontainer?.clearModel();
    }
    hoveredDate: NgbDate | null = null;

    fromDate!: NgbDate | any;
    toDate!: NgbDate | any;
    onDateSelection(daycontainer) {
        daycontainer?.clearModel();
    }

    loadData(): Observable<any> {
        this.isloader = true;
        return this.adminService.announcement(this.paginator.pageIndex + 1, this.paginator.pageSize, this.filterValue).pipe(
            tap((data: any) => {
                this.isloader = false;
                this.dataSource.data = data.queryList.data;
                setTimeout(() => {
                    this.paginator.pageIndex = data.queryList.current_page - 1;
                    this.paginator.length = data.queryList.total;
                    this.paginator.pageSize = data.queryList.per_page;
                });
            }));
    }

    onPaginateTable() {
        this.selection.clear();
        this.loadData().subscribe();
    }


    @ViewChildren('filterInput') filterInput!: QueryList<ElementRef>;
    dropdownSearch() {
        this.filterInput.changes.subscribe(res => {
            if (this.filterInput?.first) {
                this.filterInput.first.nativeElement.focus()
            }
        })
    }


    public primaryColor(data: any): void {
        this.announcementObj['primary_color'] = data.color;
    }
    public secondaryColor(data: any): void {
        this.announcementObj['secondary_color'] = data.color;
    }
    updateFromDatepickerMinDate() {
        const selectedDate = new Date(this.fromDate.year, this.fromDate.month - 1, this.fromDate.day);
        this.minFromDate = { year: selectedDate.getFullYear(), month: selectedDate.getMonth() + 1, day: selectedDate.getDate() };
    }

    // this is needed to allow sorting on nested properties
    nestedProperty = (data: any, sortHeaderId: string): string | number => {
        return sortHeaderId
            ?.split('.')
            .reduce((accumulator, key) => accumulator && accumulator[key], data) as
            | string
            | number;
    };
    // this is needed to have caseInsensitive sorting
    caseInsensitive = (data: any, sortHeaderId: string): string | number => {
        const value = data[sortHeaderId];
        return typeof value === 'string' ? value.toUpperCase() :
            value;
    };
    nestedCaseInsensitive = (data: any, sortHeaderId: string): string | number => {
        const value = sortHeaderId
            ?.split('.')
            .reduce((accumulator, key) => accumulator && accumulator[key], data) as
            | string
            | number;
        return typeof value === 'string' ? value.toUpperCase() : value;
    };
}
