import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { Router } from '@angular/router';
import { TranslatePipe } from '@ngx-translate/core';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { CommonModule } from '@angular/common';
import { FormsModule } from '@angular/forms';

@Component({
  selector: 'app-app-purchase-code',
  templateUrl: './app-purchase-code.component.html',
  styleUrls: ['./app-purchase-code.component.scss'],
  standalone : true,
  imports: [AdminPageHeaderComponent, TranslatePipes, CommonModule, FormsModule]
})
export class AppPurchaseCodeComponent extends Unsub implements OnInit {
  @ViewChild('myElement', { static: true }) myElementRef!: ElementRef;
  purchaseCodeData;
  appInfoResult = false;
  data;
  public sendingResponse: { [key: string]: boolean } = {};
  constructor(
    private adminService: AdminService,
    private toastr: ToastrService,
    private router: Router,
    private translate: TranslatePipe, loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);

  }

  ngOnInit(): void {
    this.loaderService.showLoader();
    this.adminService
      .licenseinfo()
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.data = res;
          if(res.invalid){
            this.appInfoResult = true;
          }
          console.log(res, this.appInfoResult);
          
          if (res.output) {
            const element = this.myElementRef.nativeElement;
            element.innerHTML = res.output;

            // Retrieve the h4 and button elements
            const h4Element = element.querySelector('.card-title');
            // Set the translated text for the h4 and button elements
            if (h4Element) {
              h4Element.textContent = this.translate.transform(h4Element.textContent);
            }
          }
          this.loaderService.hideLoader();
        },
        error: () => this.loaderService.hideLoader()
      });

  }

  appInfoSubmit(ngForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const data = {
        "envato_id": ngForm.value.envato_id,
      };
      this.adminService
        .licenseinfoenter(data)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));
              if (res.status == 'success') {
                this.router.navigate(['/admin/login']);
              }
            }
            if (res.error) {
              this.toastr.error(this.translate.transform(res.error));
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }
}
