import { Component } from '@angular/core';
import { SharedModule } from '../../../../shared/shared.module';
import { FormGroup, ReactiveFormsModule } from '@angular/forms';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { Unsub } from '../../../../shared/class/unsub.class';
import { ToastrService } from 'ngx-toastr';
import { TranslatePipe } from '@ngx-translate/core';
import { CheckBoxInputComponent } from '../../../../core/components/input/check-box-input/check-box-input.component';
import { NgSelectInputComponent } from '../../../../core/components/input/ng-select-input/ng-select-input.component';
import { NumberInputComponent } from '../../../../core/components/input/number-input/number-input.component';
import { EditorInputComponent } from '../../../../core/components/input/editor-input/editor-input.component';
import { FileInputComponent } from '../../../../core/components/input/file-input/file-input.component';
import { takeUntil } from 'rxjs';
import { TextInputComponent } from '../../../../core/components/input/text-input/text-input.component';
import Swal from 'sweetalert2';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';

interface BotResponeListType {
  id: number;
  name: string;
}

@Component({
  selector: 'app-botresponse-settings',
  standalone: true,
  imports: [TranslatePipes, CheckBoxInputComponent, NgSelectInputComponent, NumberInputComponent, EditorInputComponent, FileInputComponent, TextInputComponent, ReactiveFormsModule, AdminPageHeaderComponent],
  templateUrl: './botresponse-settings.component.html',
  styleUrl: './botresponse-settings.component.scss'
})
export class BotresponseSettingsComponent extends Unsub {
  setting;
  data;
  timeTypeList = [
    { id: 1, name: 'Mintutes', value: 'mintutes' },
    { id: 2, name: 'Hours', value: 'hours' },
  ]
  constructor(private adminService: AdminService, private toastr: ToastrService, private translate : TranslatePipe,  loaderService: LoaderService){
    super(loaderService);
    this.bostResponseFn();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: (res) => {
        this.bostResponseFn();
      },
    });
  }
  public botresposeList: BotResponeListType[] = [
    { id: 1, name: '{{ticket_id}}' },
    { id: 1, name: '{{ticket_username}}' },
    { id: 1, name: '{{ticket_title}}' },
    { id: 1, name: '{{ticket_status}}' },
    { id: 1, name: '{{ticket_customer_url}}' },
    { id: 1, name: '{{ticket_admin_url}}' },
  ];

  bostResponseFn() {
    this.loaderService.showLoader();
    // this.isloader = true;
    this.adminService.botresponsettingcreate()
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.data = res;
          this.setting = res.settings;
        }
      })
  }

  responseSetting = new FormGroup({});
  botResponse(name, main){
    if (name.valid) {
      let formData = new FormData();
      for (const key in name.value) {
        if (name.value.hasOwnProperty(key) && !this.responseSetting[key]) {
          formData.append(key, name.value[key]);
        }
        if(this.responseSetting[key]){
          formData.append(key, this.responseSetting[key])
        }
      }
      this.adminService[main](formData).subscribe({
        next: res => {
          if (res?.success) {
            this.toastr.success(this.translate.transform(res.success));
          }
        }
      })
    }
  }
  handlePatchValue(patchValueData: any, group, name) {
    this.responseSetting[name] = patchValueData;
  }
  removeBotImage(){

    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure you want to remove the Bot profile image?'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Yes, Remove it!'),
      cancelButtonText: this.translate.transform('Close'),
      reverseButtons: true,
  }).then((result: any) => {
      if (result.isConfirmed) {
        this.adminService.botimagedelete().pipe(takeUntil(this.unSubscribe$)).subscribe({
            next: (res) => {
              if (res?.success) {
                this.toastr.success(this.translate.transform(res.success));
              }
            }
        });
      }
  });
  }
}
