import { ToastrService } from 'ngx-toastr';
import { Component, OnInit } from '@angular/core';
import { takeUntil } from 'rxjs';
import { TranslatePipe } from '@ngx-translate/core';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { FormsModule } from '@angular/forms';

@Component({
  selector: 'app-external-chat',
  templateUrl: './external-chat.component.html',
  styleUrls: ['./external-chat.component.scss'],
  standalone : true,
  imports: [AdminPageHeaderComponent, TranslatePipes, FormsModule]
})
export class ExternalChatComponent extends Unsub implements OnInit {
  public sendingResponse: { [key: string]: boolean } = {};
  constructor(
    public adminService: AdminService,
    private toastr: ToastrService,
    private translate: TranslatePipe,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
  }

  Responce: any;
  ngOnInit(): void {
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => this.externalChat()
    });
    this.externalChat();
  }
  externalChat() {
    this.loaderService.showLoader();
    this.adminService.customchatsetting().subscribe({
      next: (res) => {
        this.Responce = res;
        this.loaderService.hideLoader();
      }, error: () => this.loaderService.hideLoader()
    });
  }

  ExternalChatSetting(data: any, buttonId) {

    const PostData = {
      CUSTOMCHATUSER: data.value.CUSTOMCHATUSER,
      customchat: data.value.customchat,
    };
    if (data.value.CUSTOMCHATENABLE) {
      PostData['CUSTOMCHATENABLE'] = data.value.CUSTOMCHATENABLE;
    }
    this.sendingResponse[buttonId] = true;
    this.adminService
      .customchats(PostData)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.sendingResponse[buttonId] = false;
          this.toastr.success(this.translate.transform(res.success));
        },
        error: () => {
           this.sendingResponse[buttonId] = false;
        },
      }
      );
  }
}
