import { Component, OnInit } from '@angular/core';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { FormsModule } from '@angular/forms';

@Component({
  selector: 'app-google-analytics',
  templateUrl: './google-analytics.component.html',
  styleUrls: ['./google-analytics.component.scss'],
  standalone : true,
  imports: [AdminPageHeaderComponent, TranslatePipes, FormsModule]
})
export class GoogleAnalyticsComponent extends Unsub implements OnInit {
  public sendingResponse: { [key: string]: boolean } = {};
  constructor(
    private adminService: AdminService,
    private toastr: ToastrService,
    private translate: TranslatePipe,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
  }

  ngOnInit(): void {
    this.getgoogleanalytics();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => this.getgoogleanalytics()
    });
  }

  public responce: any;
  getgoogleanalytics() {
    this.loaderService.showLoader();
    this.adminService.googleanalytics().subscribe({
      next: (ele) => {this.responce = ele;this.loaderService.hideLoader()},
      error: () => this.loaderService.hideLoader()
    });
  }

  GoogleAnalytics(data: any, buttonId) {
    //
    const PostData = {
      GOOGLE_ANALYTICS: data.GOOGLE_ANALYTICS,
    };
    if (data.GOOGLE_ANALYTICS_ENABLE == true) {
      PostData['GOOGLE_ANALYTICS_ENABLE'] = data.GOOGLE_ANALYTICS_ENABLE;
    }
    this.sendingResponse[buttonId] = true;
    this.adminService
      .GoogleAnalytics(PostData)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.sendingResponse[buttonId] = false;
          this.toastr.success(this.translate.transform(res.success));
        },
        error: () => {
           this.sendingResponse[buttonId] = false;
        },
      });
  }
}
