import { Component, ViewChild, viewChild } from '@angular/core';
import { FormsModule } from '@angular/forms';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';

@Component({
  selector: 'app-payments-gateways',
  standalone: true,
  imports: [AdminPageHeaderComponent, TranslatePipes, FormsModule],
  templateUrl: './payments-gateways.component.html',
  styleUrl: './payments-gateways.component.scss'
})
export class PaymentsGatewaysComponent extends Unsub {

  @ViewChild('paypalDefault') paypalDefault: any;
  @ViewChild('stripeDefault') stripeDefault: any;

  public sendingResponse: { [key: string]: boolean } = {};
  setting;
  constructor(
    private adminService: AdminService,
    private toastr: ToastrService,
    private translate: TranslatePipe,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
  }

  ngOnInit(): void {
    this.getgoogleanalytics();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => this.getgoogleanalytics()
    });
  }

  public responce: any;
  getgoogleanalytics() {
    this.loaderService.showLoader();
    this.adminService.paymentGateways().subscribe({
      next: (ele) => {
        this.responce = ele;
        this.setting = ele.settings;
        this.loaderService.hideLoader()
      },
      error: () => this.loaderService.hideLoader()
    });
  }

  stripeStore(data: any, buttonId) {
    this.sendingResponse[buttonId] = true;
    this.adminService
      .stripeStore(data)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.sendingResponse[buttonId] = false;
          if (res.success) {
            this.toastr.success(this.translate.transform(res.success));
          }
          if (res.geminiKey) {
            this.toastr.error(this.translate.transform(res.geminiKey));
          }
        },
        error: () => {
          this.sendingResponse[buttonId] = false;
        },
      });
  }
  paypalStore(data: any, buttonId) {
    this.sendingResponse[buttonId] = true;
    this.adminService
      .paypalStore(data)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.sendingResponse[buttonId] = false;
          if (res.success) {
            this.toastr.success(this.translate.transform(res.success));
          }
          if (res.geminiKey) {
            this.toastr.error(this.translate.transform(res.geminiKey));
          }
        },
        error: () => {
          this.sendingResponse[buttonId] = false;
        },
      });
  }
  refundsSetting(data: any, buttonId) {
    this.sendingResponse[buttonId] = true;
    this.adminService
      .refundSettings(data)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.sendingResponse[buttonId] = false;
          if (res.success) {
            this.toastr.success(this.translate.transform(res.success));
          }
          if (res.geminiKey) {
            this.toastr.error(this.translate.transform(res.geminiKey));
          }
        },
        error: () => {
          this.sendingResponse[buttonId] = false;
        },
      });
  }
  invoiceCancellationSetting(data: any, buttonId) {
    this.sendingResponse[buttonId] = true;
    this.adminService
      .autoInvoiceCancelSetting(data)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.sendingResponse[buttonId] = false;
          if (res.success) {
            this.toastr.success(this.translate.transform(res.success));
          }
          if (res.geminiKey) {
            this.toastr.error(this.translate.transform(res.geminiKey));
          }
        },
        error: () => {
          this.sendingResponse[buttonId] = false;
        },
      });
  }
  autodeleteinvoiceSetting(data: any, buttonId) {
    this.sendingResponse[buttonId] = true;
    this.adminService
      .autoInvoicedeleteSetting(data)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.sendingResponse[buttonId] = false;
          if (res.success) {
            this.toastr.success(this.translate.transform(res.success));
          }
          if (res.geminiKey) {
            this.toastr.error(this.translate.transform(res.geminiKey));
          }
        },
        error: () => {
          this.sendingResponse[buttonId] = false;
        },
      });
  }


  updateDefaultPay = (event, payType) => {
    let checked = event.target?.checked;
    if (payType === "stripeDefault") {
      if (checked) {
        this.paypalDefault.nativeElement.checked = false;
        this.updateSettingsFn("stripeDefault", "on");
      } else {
        this.updateSettingsFn("stripeDefault", "off");
      }
    }
    else if (payType === "paypalDefault") {
      if (checked) {
        this.stripeDefault.nativeElement.checked = false;
        this.updateSettingsFn("paypalDefault", "on");
      } else {
        this.updateSettingsFn("paypalDefault", "off");
      }
    }
  }
  updateSettingsFn(setting, value) {
    this.adminService.updateSettings({ setting: setting, value: value }).subscribe(res => {
      if (res.success) {
        this.toastr.success(this.translate.transform(res.success));
      } else {
        console.error(`Failed to update ${setting}`);
      }
    })
  }
}
