import { Component, OnInit } from '@angular/core';
import { ToastrService } from 'ngx-toastr';
import { Meta } from '@angular/platform-browser';
import { takeUntil } from 'rxjs';
import { TranslatePipe } from '@ngx-translate/core';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { SeoService } from '../../../../shared/services/admin/seo.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { NgSelectModule } from '@ng-select/ng-select';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { FormsModule } from '@angular/forms';

@Component({
  selector: 'app-seo',
  templateUrl: './seo.component.html',
  styleUrls: ['./seo.component.scss'],
  standalone : true,
  imports: [AdminPageHeaderComponent, TranslatePipes, NgSelectModule, FormsModule]
})
export class SEOComponent extends Unsub implements OnInit {
  public seoId: any;
  public author: any;
  public description: any;
  public keywords: any;
  public sendingResponse: { [key: string]: boolean } = {};
  constructor(
    private seoService: SeoService,
    private toastr: ToastrService,
    private meta: Meta,
    private adminService: AdminService,
    private translate: TranslatePipe,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.settingInprogress();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
      ).subscribe({
        next: () => {
          this.settingInprogress();
        },
      });
    }
    settingInprogress = () => {
      this.loaderService.showLoader();
      this.seoService
        .index()
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (ele) => {
            this.seoId = ele.seopage.id;
            this.author = ele.seopage.author;
            this.description = ele.seopage.description;
            this.keywords = ele.seopage?.keywords?.split(',');
            this.loaderService.hideLoader();
          },
          error : ()=>this.loaderService.hideLoader()
        });
    };

  ngOnInit(): void { }

  ChangeTheValues(data: any, buttonId) {
    if (data.valid) {
      this.sendingResponse[buttonId] = true;
        const PostData = {
        author: data.value.author,
        description: data.value.description,
        keywords: data.value.keywords?.join(','),
        "seo_id": this.seoId,
      };
      this.seoService
        .seoStore(PostData)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            this.toastr.success(this.translate.transform(res.success));
          },
          error: () => {
             this.sendingResponse[buttonId] = false;
          },
        });

      //remove
      this.meta.removeTag("name='author'");
      this.meta.removeTag("name='description'");
      this.meta.removeTag("name='keywords'");

      this.meta.updateTag({ name: 'author', content: this.author });
      this.meta.updateTag({ name: 'description', content: this.description });
      this.meta.updateTag({ name: 'keywords', content: this.keywords });
    }
  }
}
