import { Component, OnInit } from '@angular/core';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { FormsModule } from '@angular/forms';

@Component({
  selector: 'app-under-maintenance-page',
  templateUrl: './under-maintenance-page.component.html',
  styleUrls: ['./under-maintenance-page.component.scss'],
  standalone : true,
  imports: [AdminPageHeaderComponent, TranslatePipes, FormsModule]
})
export class UnderMaintenancePageComponent extends Unsub implements OnInit {
  public sendingResponse: { [key: string]: boolean } = {};
  underMaint: any;
  constructor(
    private adminService: AdminService,
    private Toastr: ToastrService,
    private translate: TranslatePipe,
    loaderService: LoaderService
  ) {
     /**
     * This code calls the constructor of the parent class in a subclass. 
     * The super() function is used to initialize the parent class and allows access to its properties and methods. 
     * By calling  super(), the subclass can inherit and use the functionality of the parent class.
     **/
super(loaderService);
this.loaderService.showLoader();
    this.adminService
      .maintenancepage()
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.underMaint = res;
          this.loaderService.hideLoader();
        },
        error : ()=> this.loaderService.hideLoader()
      });
  }

  ngOnInit(): void {
  }

  maintenance(ngForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      this.adminService
        .maintenancepageEdit(ngForm.value)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.Toastr.success(this.translate.transform(res.success));
            }
            if (res.error) {
              this.Toastr.error(this.translate.transform(res.error.error.message));
            }
          },
          error: () => {
             this.sendingResponse[buttonId] = false;
          },
        });
    }
  }
}
