import { SelectionModel } from '@angular/cdk/collections';
import { Component, OnInit, ViewChild } from '@angular/core';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { MatTableDataSource } from '@angular/material/table';
import { ActivatedRoute, RouterLink } from '@angular/router';
import { TranslatePipe } from '@ngx-translate/core';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { NgSelectModule } from '@ng-select/ng-select';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { AdminTicketTableComponent } from '../../../../shared/common/includes/admin-ticket-table/admin-ticket-table.component';

@Component({
  selector: 'app-customer-ticket-history',
  templateUrl: './customer-ticket-history.component.html',
  styleUrls: ['./customer-ticket-history.component.scss'],
  standalone : true,
  imports: [AdminPageHeaderComponent, TranslatePipes, NgSelectModule, RouterLink,AdminTicketTableComponent ]
})
export class CustomerTicketHistoryComponent extends Unsub implements OnInit {
  data;
  userId: any;
  isloader = true;
  public sendingResponse: { [key: string]: boolean } = {};
  public assignedMem: any = [];
  public userDetails: any;
  public ticketDetails: any;
  timezone;
  displayedColumns: string[] = [
    'id',
    'select',
    'ticketdetails',
    'user',
    'status',
    'assignto',
    'actions',
  ];
  dataSource!: MatTableDataSource<any>;
  selection = new SelectionModel<any>(true, []);
  @ViewChild(MatPaginator) paginator!: MatPaginator;
  @ViewChild(MatSort) sort!: MatSort;
  permission: any;
  setting: any;
  activeTickets: any;

  constructor(private adminService: AdminService, private activedRoute: ActivatedRoute, private translate: TranslatePipe,
    loaderService: LoaderService) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    activedRoute.params.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (params) => {
        this.userId = params['id'];
        this.customerPreviousTickets();

      }
    });
  }

  ngOnInit(): void {
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        this.customerPreviousTickets();
      }
    });
  }

  customerPreviousTickets() {
    this.loaderService.showLoader();
    this.adminService.customerprevioustickets(this.userId, 1, 10, '').subscribe({
      next: res => {
        this.data = res;
        this.permission = res.permissions;
        this.timezone = res?.timezonedata;
        this.setting = res.setting?.original;
        this.isloader = false;
        this.activeTickets = res.queryList;
        if (!this.permission?.includes('Ticket Delete')) {
          this.displayedColumns = [
            'id',
            'ticketdetails',
            'user',
            'status',
            'assignto',
            'actions',
          ];
        }
        this.loaderService.hideLoader();
      },
      error: () => this.loaderService.hideLoader()
    });
  }
  
  loadData(params) {
    this.isloader = true;
    this.adminService.customerprevioustickets(this.userId, params.page, params.size, params.filter).subscribe(
      {
        next: (data: any) => {
          this.isloader = false;
          this.activeTickets = data.queryList;
        },
        error : err => this.isloader = false
      });
  }
}
