import { Component, ElementRef, OnInit, Renderer2 } from '@angular/core';
import { Subject, takeUntil } from 'rxjs';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { TranslatePipe, TranslateService } from '@ngx-translate/core';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { CommonModule } from '@angular/common';
import { SharedModule } from '../../../../shared/shared.module';
import { NgSelectModule } from '@ng-select/ng-select';
import { RouterLink } from '@angular/router';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { NgbAlertModule } from '@ng-bootstrap/ng-bootstrap';
import { AdminTicketTableComponent } from '../../../../shared/common/includes/admin-ticket-table/admin-ticket-table.component';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';

@Component({
  selector: 'app-dashboard',
  templateUrl: './dashboard.component.html',
  styleUrls: ['./dashboard.component.scss'],
  standalone : true,
  imports : [CommonModule, TranslatePipes, NgSelectModule, RouterLink, NgbAlertModule, AdminTicketTableComponent, AdminPageHeaderComponent ],
  providers: [TranslatePipe, TranslatePipes]
})
export class DashboardComponent extends Unsub implements OnInit {

  public activeTickets: any;
  setting;
  public countDetails: any = {};
  timezone;

  paginationOptions = {
    pageSize: 10,
    total: 0,
    pageIndex: 1
  }
  displayedColumns: string[] = [
    'id',
    'select',
    'ticketdetails',
    'user',
    'status',
    'assignto',
    'actions',
  ];
  Auth: any;
  permission: any;
  isloader = true;

  refreshToken$;
  mailnotify: any = [];
  constructor(
    private adminService: AdminService,
    private translate: TranslateService,
    loaderService: LoaderService,
    private sanitizer: DomSanitizer,
    private renderer: Renderer2,
    private elementRef: ElementRef
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);

    let users = localStorage.getItem('user');
    users ? this.Auth = JSON.parse(users) : {};
    this.countDetails['user'] = this.Auth?.dashboard;

    this.dashboardCout();
    this.RecentTicketList();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        this.dashboardCout();
        this.RecentTicketList();
      },
    });
  }
  private searchTerms = new Subject<string>();
  ngOnInit(): void {
  }
  
  dashboardCout() {
    this.adminService
      .adminDashboardCount()
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (ele: any) => {
          this.countDetails = ele;
        },
      });
  }
  RecentTicketList() {
    this.loaderService.showLoader();
    this.isloader = true;
    this.adminService
      .adminDashboard(1, 10, '')
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (ele: any) => {
          if (ele) {
            this.Auth = ele.user;
            this.permission = ele.permissions;
            this.mailnotify = ele.mailnotify;
            this.activeTickets = ele.queryList;
            const keyframes = `
            .content{
              animation-duration : ${this.mailnotify.length * 2}s !important;
            }
              @keyframes scrollAnimation {
                0% {
                  transform: translateY(${this.mailnotify.length * 40}%);
                }
                100% {
                  transform: translateY(-${(2 * this.mailnotify.length) * 40}%);
                }
              }
            `;
            const styleElement = this.renderer.createElement('style');
            this.renderer.appendChild(styleElement, this.renderer.createText(keyframes));
            this.renderer.appendChild(this.elementRef.nativeElement, styleElement);
            this.timezone = ele.timezonedata;
            this.isloader = false;
            this.setting = ele.setting?.original;
          }
          if (!this.permission?.includes('Ticket Delete')) {
            this.displayedColumns = [
              'id',
              'ticketdetails',
              'user',
              'status',
              'assignto',
              'actions',
            ];
          }
          this.loaderService.hideLoader();
        },
        error: () => { this.isloader = true; this.loaderService.hideLoader() }
      });
  }



  loadData(params) {
    this.isloader = true;
    this.adminService.adminDashboard(params.page, params.size, params.filter).subscribe(
      {
        next: (data: any) => {
          this.isloader = false;
          this.activeTickets = data.queryList;
        },
        error : err => this.isloader = false
      });
  }

  sendMarkRequest(id) {
    const data = {

      id: id,
    };
    this.adminService
      .markReq(data)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({ next: () => { } });
  }
  sanitizeHtml(html: string): SafeHtml {
    return this.sanitizer.bypassSecurityTrustHtml(html);
  }
  animationPlayState: string = 'running';
  stopScroll() {
    this.animationPlayState = 'paused';
  }
  startScroll() {
    this.animationPlayState = 'running';
  }
}
