import { Component } from '@angular/core';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { AdminService } from '../../../shared/services/admin/admin.service';

import { FormsModule } from '@angular/forms';
import { TranslatePipes } from '../../../shared/pipes/translate/translate.pipe';
import { SharedModule } from '../../../shared/shared.module';
import { NgbModal, NgbModalModule, NgbTooltipModule } from '@ng-bootstrap/ng-bootstrap';
import { NavigationEnd, Router } from '@angular/router';
import { LoaderService } from '../../../shared/services/loader.service';
import { Title } from '@angular/platform-browser';
import { AdminPageHeaderComponent } from '../../../shared/common/pageheader/admin-page-header/admin-page-header.component';

@Component({
  selector: 'app-domaintransfer',
  standalone: true,
  templateUrl: './domaintransfer.component.html',
  styleUrl: './domaintransfer.component.scss',
  imports: [FormsModule, TranslatePipes, NgbTooltipModule, NgbModalModule, AdminPageHeaderComponent],
  providers: [TranslatePipes, TranslatePipe]
})
export class DomaintransferComponent {
  settingToken;
  userId;
  href;
  base;
  public sendingResponse: { [key: string]: boolean } = {};
  token: string | null = null;
  constructor(private adminService: AdminService, private toastr: ToastrService, private translate: TranslatePipe, private titleService: Title, private loaderService: LoaderService,
    private modalService: NgbModal,) {
    let users = localStorage.getItem('user');
    this.settingToken = localStorage.getItem('token');
    if (users) {
      let user = JSON.parse(users);
      this.userId = user?.id
    }
    this.href = location.origin;
    this.base = document.querySelector('base')?.getAttribute('href');

  }

  requesttoken(buttonId) {
    this.sendingResponse[buttonId] = true;
    this.adminService.requesttoken().subscribe({
      next: res => {
        this.sendingResponse[buttonId] = false;
        if (res?.code) {
          this.toastr.error(this.translate.transform(res?.code));
        }
        if (res?.token) {
          this.token = res.token;
        }
      },
      error: err => this.sendingResponse[buttonId] = false
    })
  }
  tokenGenerate(buttonId) {
    this.sendingResponse[buttonId] = true;
    this.adminService.tokenGenerate().subscribe({
      next: res => {
        this.sendingResponse[buttonId] = false;
        if (res?.code) {
          this.toastr.error(this.translate.transform(res?.code));
        }
        if (res?.error) {
          this.toastr.error(this.translate.transform(res?.error));
        }
        if (res?.token) {
          this.toastr.success(this.translate.transform('Token generated Successfully.'));
          this.token = res.token;
        }
      },
      error: err => this.sendingResponse[buttonId] = false
    })
  }
  exportFile(buttonId, content) {
    // Open the modal
    const modalRef = this.modalService.open(content, {
      size: 'lg',
      backdrop: 'static',
      keyboard: false,
      centered: true
    });
    const downloadUrl = `${this.href}${this.base}detail/admin/download-files`; // Replace with actual URL
    const filename = this.titleService.getTitle() + '.zip';
    const callback = () => {
      this.modalService.dismissAll();
    };
    this.loaderService.downloadFile(downloadUrl, filename, callback);
  }
  database(buttonId, content) {
    this.modalService.open(content, {
      size: 'lg',
      backdrop: 'static', keyboard: false,
      centered: true
    });
    const downloadUrl = `${this.href}${this.base}detail/admin/exportDatabase`; // Replace with actual URL
    const filename = this.titleService.getTitle() + '.sql';
    const callback = () => {
      this.modalService.dismissAll();
    };
    this.loaderService.downloadFile(downloadUrl, filename, callback);
  }
}
