import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { FormsModule } from '@angular/forms';

@Component({
  selector: 'app-envato-license-verfication',
  templateUrl: './envato-license-verfication.component.html',
  styleUrls: ['./envato-license-verfication.component.scss'],
  standalone : true,
  imports: [AdminPageHeaderComponent, TranslatePipes, FormsModule]
})
export class EnvatoLicenseVerficationComponent extends Unsub implements OnInit {
  public sendingResponse: { [key: string]: boolean } = {};
  constructor(private adminService: AdminService, loaderService: LoaderService) {  /**
     * This code calls the constructor of the parent class in a subclass. 
     * The super() function is used to initialize the parent class and allows access to its properties and methods. 
     * By calling  super(), the subclass can inherit and use the functionality of the parent class.
     **/
    super(loaderService);
  }

  @ViewChild('dataenvato') dataenvato!: ElementRef;
  ngOnInit(): void {
  }

  verifyLicenese(ngForm, buttonId) {
    const data = {
      "envato_search": ngForm.value.envato_search
    };
    this.sendingResponse[buttonId] = true;
    this.adminService.envatolicensesearch(data).pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: res => {
        this.sendingResponse[buttonId] = false;
        this.dataenvato.nativeElement.innerHTML = res;
      },
      error: () => {
        this.sendingResponse[buttonId] = false;
      },
    });

  }
}
