import { Component, OnInit } from '@angular/core';
import { TranslatePipe } from '@ngx-translate/core';
import { Subscription, takeUntil } from 'rxjs';
import { Unsub } from '../../../../../shared/class/unsub.class';
import { AdminService } from '../../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../../shared/services/loader.service';

import { FormsModule } from '@angular/forms';
import { TranslatePipes } from '../../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { AdminTicketTableComponent } from '../../../../../shared/common/includes/admin-ticket-table/admin-ticket-table.component';

@Component({
  selector: 'app-onhold',
  templateUrl: './onhold.component.html',
  styleUrls: ['./onhold.component.scss'],
  standalone: true,
  imports: [AdminPageHeaderComponent, TranslatePipes, FormsModule, AdminTicketTableComponent],
})
export class OnholdComponent extends Unsub implements OnInit {
  public activeTickets: any;
  public alltickets$!: Subscription;
  timezone;
  setting;

  displayedColumns: string[] = [
    'id',
    'select',
    'ticketdetails',
    'user',
    'status',
    'assignto',
    'actions',
  ];
  permission: any;
  isloader = true;

  constructor(
    private adminService: AdminService,
    private translate: TranslatePipe,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
  }

  ngOnInit(): void {
    this.activeticketOnhold();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => this.activeticketOnhold()
    });
  }
  activeticketOnhold() {
    this.loaderService.showLoader();
    this.isloader = true;
    this.alltickets$ = this.adminService
      .activeticketOnhold(1, 10, '')
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.permission = res.permissions;
          this.activeTickets = res.queryList;

          this.timezone = res?.timezonedata;
          this.isloader = false;
          this.setting = res.setting?.original;
          if (!this.permission?.includes('Ticket Delete')) {
            this.displayedColumns = [
              'id',
              'ticketdetails',
              'user',
              'status',
              'assignto',
              'actions',
            ];
          }
          this.loaderService.hideLoader();
        },
        error: () => { this.isloader = true; this.loaderService.hideLoader() }
      });
  }

  loadData(params) {
    this.isloader = true;
    this.adminService.activeticketOnhold(params.page, params.size, params.filter).subscribe(
      {
        next: (data: any) => {
          this.isloader = false;
          this.activeTickets = data.queryList;
        },
        error : err => this.isloader = false
      });
  }
}
