import { Component, OnInit } from '@angular/core';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { TranslatePipe } from '@ngx-translate/core';
import { Subscription, takeUntil } from 'rxjs';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { FormsModule } from '@angular/forms';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { AdminTicketTableComponent } from '../../../../shared/common/includes/admin-ticket-table/admin-ticket-table.component';
@Component({
  selector: 'app-total-tickets',
  templateUrl: './total-tickets.component.html',
  styleUrls: ['./total-tickets.component.scss'],
  standalone: true,
  imports: [AdminPageHeaderComponent, TranslatePipes, FormsModule, AdminTicketTableComponent],
  
})
export class TotalTicketsComponent extends Unsub implements OnInit {
  public activeTickets: any;
  public alltickets$!: Subscription;
  setting;
  displayedColumns: string[] = [
    'id',
    'select',
    'ticketdetails',
    'user',
    'status',
    'assignto',
    'actions',
  ];
  isloader = true;
  timezone: any;
  permission: any;

  constructor(
    private adminService: AdminService,
    private modalService: NgbModal,
    private translate: TranslatePipe,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
  }

  ngOnInit(): void {
    this.allticketsFn();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => this.allticketsFn()
    });
  }
  allticketsFn() {
    this.isloader = true;
    this.loaderService.showLoader();
    this.alltickets$ = this.adminService
      .alltickets(1, 10, '')
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.timezone = res?.timezonedata;
          this.permission = res.permissions;
          this.activeTickets = res.queryList;
          // Assign the data to the data source for the table to render
          this.isloader = false;
          this.setting = res.setting?.original;

          if (!this.permission?.includes('Ticket Delete')) {
            this.displayedColumns = [
              'id',
              'ticketdetails',
              'user',
              'status',
              'assignto',
              'actions',
            ];
          }
          this.loaderService.hideLoader();
        },
        error: () => { this.isloader = true; this.loaderService.hideLoader() }
      });
  }


  loadData(params) {
    this.isloader = true;
    this.adminService.alltickets(params.page, params.size, params.filter).subscribe(
      {
        next: (data: any) => {
          this.isloader = false;
          this.activeTickets = data.queryList;
        },
        error : err => this.isloader = false
      });
  }
  override ngOnDestroy() {
    this.modalService?.dismissAll();
  }
}
