import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, FormsModule, NgForm } from '@angular/forms';
import { ActivatedRoute, Router, RouterLink } from '@angular/router';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { AngularEditorConfig, AngularEditorModule } from '@kolkov/angular-editor';
import { Unsub } from '../../../../shared/class/unsub.class';
import { adminToolbar } from '../../../../shared/data/editortoolbar';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { NgSelectModule } from '@ng-select/ng-select';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { ImageUploadComponent } from '../../../../shared/common/includes/image-upload/image-upload.component';
import { MaxLengthValidatorDirective } from '../../../../shared/directives/max-length-validator.directive';

@Component({
  selector: 'app-ticketarticle',
  templateUrl: './ticketarticle.component.html',
  styleUrls: ['./ticketarticle.component.scss'],
  standalone : true,
  imports: [AdminPageHeaderComponent, TranslatePipes, NgSelectModule, FormsModule, AngularEditorModule, RouterLink, ImageUploadComponent, MaxLengthValidatorDirective]
})
export class TicketarticleComponent extends Unsub implements OnInit {
  ticketid!: string | null;
  data: any;
  hassubcategoriess = [];
  ticketName: any[] = [];
  form: FormGroup;
  ticketName2: any[] = [];
  form2: FormGroup;
  public sendingResponse: { [key: string]: boolean } = {};
  toolbar: AngularEditorConfig = adminToolbar;
  commentId: string | any;
  articleArr: any[] = [];
  setting;
  public featureimageArr: any[] = [];
  constructor(private adminService: AdminService, private activeRoute: ActivatedRoute, private toastr: ToastrService,
    public fb: FormBuilder, private router: Router,
    private translate: TranslatePipe,
    loaderService: LoaderService) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);

    this.activeRoute.paramMap.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (params) => {
        this.ticketid = params.get('ticket');
        this.commentId = params.get('id');
        this.loaderService.showLoader();
        this.adminService.ticketarticle(this.ticketid, this.commentId).pipe(takeUntil(this.unSubscribe$)).subscribe({
          next: (res) => {
            this.data = res;
            this.hassubcategoriess = res.subcategory;
            this.setting = res.setting?.original;
            this.loaderService.hideLoader();
          },
          error: () => this.loaderService.hideLoader()
        });
      }
    });

    this.form = this.fb.group({
      image: null,
    });
    this.form2 = this.fb.group({
      image: null,
    });
    this.toolbar.placeholder = this.translate.transform('Enter Your Text...');
  }

  ngOnInit(): void {
  }

  categorychange(id) {
    const data = {
      "cat_id": id,
    };
    this.adminService.getCatagoryData(data).subscribe({
      next: (res) => {
        this.hassubcategoriess = res.subcategories;
      },
    });
  }

  tagslist: any[] = [];
  article: File[] = [];
  createArticle(createarticle: NgForm, buttonId) {
    if (createarticle.valid) {
      this.sendingResponse[buttonId] = true;

      const artImg: any[] = [];
      this.article.forEach((e) => {
        artImg.push(e?.name);
      });
      const formData: any = new FormData();

      for (const key of Object.keys(createarticle.value)) {
        if(key != "tags"){
          formData.append(key, createarticle.value[key]);
        }
      }

      formData.append('tags', createarticle.value.tags && createarticle.value.tags.length > 1 ? createarticle.value.tags.join(',') : createarticle.value.tags?.[0]);
      for (let i = 0; i < this.articleArr?.length; i++) {
        formData.append('article[]', this.articleArr[i]);
      }
      for (let i = 0; i < this.featureimageArr?.length; i++) {
        formData.append('featureimage', this.featureimageArr[i]);
      }

      this.adminService
        .createArtical(formData)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.router.navigate(['/admin/knowledge/articles']);
              createarticle.resetForm();
              this.featureimageArr = [];
              this.articleArr = [];
              this.article = [];
              this.ticketName2 = [];
              this.ticketName = [];
              this.tagslist = [];
              this.form.reset({});
              this.form2.reset({});
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }


  onImageUploaded(value) {
    this.featureimageArr = value.ticketName;
  }
  onImageUploaded2(value) {
    this.articleArr = value.ticketName;
  }
}
