import { SelectionModel } from '@angular/cdk/collections';
import { Component, OnInit, ViewChild } from '@angular/core';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { MatTableDataSource } from '@angular/material/table';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { Router } from '@angular/router';
import { NgbModal, NgbTooltipModule } from '@ng-bootstrap/ng-bootstrap';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { Subject, takeUntil, debounceTime, distinctUntilChanged, switchMap, Observable, tap } from 'rxjs';
import Swal from 'sweetalert2';
import { AngularEditorConfig, AngularEditorModule } from '@kolkov/angular-editor';
import { Unsub } from '../../../../../shared/class/unsub.class';
import { adminToolbar } from '../../../../../shared/data/editortoolbar';
import { AdminService } from '../../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../../shared/services/loader.service';
import { TranslationService } from '../../../../../shared/services/translation.service';
import { NgSelectModule } from '@ng-select/ng-select';
import { MaterialeModules } from '../../../../../material.module';
import { TranslatePipes } from '../../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { FormsModule } from '@angular/forms';
@Component({
  selector: 'app-faqs',
  templateUrl: './faqs.component.html',
  styleUrls: ['./faqs.component.scss'],
  standalone : true,
  imports: [AdminPageHeaderComponent, TranslatePipes, NgSelectModule, AngularEditorModule, MaterialeModules, NgbTooltipModule, FormsModule]
})
export class FaqsComponent extends Unsub implements OnInit {
  basic;
  loading = true;
  private searchTerms = new Subject<string>();
  faqcategoryList;
  public sendingResponse: { [key: string]: boolean } = {};
  settings;
  displayedColumns: string[] = [
    'sno',
    'select',
    'question',
    'answer',
    'faqcategory',
    'privacymode',
    'status',
    'actions',
  ];
toolbar: AngularEditorConfig = adminToolbar;
  dataSource!: MatTableDataSource<any>;
  selection = new SelectionModel<any>(true, []);
  Auth: any;
  permission: any;
  isloader = true;

  refreshToken$;
  @ViewChild(MatPaginator) paginator!: MatPaginator;
  @ViewChild(MatSort) sort!: MatSort;
  faqs: any;

  constructor(
    private adminService: AdminService,
    private router: Router,
    private toastr: ToastrService,
    private modalService: NgbModal,
    private translate: TranslatePipe,
    private translationService: TranslationService,
    loaderService: LoaderService,
    private sanitizer: DomSanitizer
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.faqsBoxRes();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        this.faqsBoxRes();

      },
    });
    this.translationService.TranslationStatus.subscribe(() => {
      setTimeout(() => {
        this.paginator._intl.itemsPerPageLabel = this.translate.transform('items per page:');
        this.paginator._intl.nextPageLabel = this.translate.transform('next');
        this.paginator._intl.previousPageLabel = this.translate.transform('previous');
        this.paginator._intl.firstPageLabel = this.translate.transform('first page');
        this.paginator._intl.lastPageLabel = this.translate.transform('last page');
        const of = this.translate.transform('of');
        this.paginator._intl.getRangeLabel = (page: number, pageSize: number, length: number) => {
          if (length == 0 || pageSize == 0) return `0 ${of} ${length}`;
          length = Math.max(length, 0);
          const startIndex = page * pageSize;
          const endIndex = startIndex < length ? Math.min(startIndex + pageSize, length) : startIndex + pageSize;

          return `${startIndex + 1} - ${endIndex} ${of} ${length}`;
        };
      }, 100);
    });
    this.translationService.setTranslationaStatus(true);
    this.toolbar.placeholder = this.translate.transform('Enter Your Text...');
  }

  ngOnInit(): void {
    this.searchTerms.pipe(
      debounceTime(300),
      distinctUntilChanged(),
      switchMap((): any => this.loadData())
    ).subscribe();
  }

  faqsBoxRes() {

    this.loaderService.showLoader();
    this.isloader = true;
    this.adminService
      .faqSection(1, 10, this.filterValue)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.permission = res.permissions;
          this.settings = res.setting?.original;
          this.basic = res.basic;
          this.faqcategoryList = res.faqcategoryList;
          this.isloader = false; this.faqs = res.queryList;
          this.loading = false;
          this.dataSource = new MatTableDataSource(this.faqs.data);

          if (this.dataSource) {
            this.paginator.pageSize = this.faqs.per_page;
            setTimeout(() => {
              this.paginator.pageIndex = this.faqs.current_page - 1;
              this.paginator.length = this.faqs.total;
            });
            this.dataSource.paginator = this.paginator;
            
              // this.sort.disableClear = true; // Used to disbale the original soting of data if enabled (Only ASC, DES).
              this.dataSource.sort = this.sort;
              this.dataSource.sortingDataAccessor = (data, sortHeaderId) => {
                switch (sortHeaderId) {
                  case 'user' || 'ticketdetails' || 'status':
                    return this.nestedProperty(data, sortHeaderId);
                  default:
                    return this.nestedCaseInsensitive(data, sortHeaderId);
                }
              }
          }
          if (!this.permission?.includes('FAQs Delete')) {
            this.displayedColumns = [
              'sno',
              'question',
              'answer',
              'faqcategory',
              'privacymode',
              'status',
              'actions',
            ];
          }
          this.loaderService.hideLoader();
        },
        error: () => { this.loaderService.hideLoader(); this.isloader = true }
      }); this.isloader = true;
  }
  faqSection(ngForm, buttonId) {
    if (ngForm.valid) {
      const data = {

        id: ngForm.value.id,
        faqtitle: ngForm.value.faqtitle,
        faqsub: ngForm.value.faqsub,
        faqcheck: ngForm.value.faqcheck ? true : undefined,
      };
      if (ngForm.value.faqcheck == true || ngForm.value.faqcheck == 'on') {
        data['faqcheck'] = ngForm.value.faqcheck;
      }
      this.sendingResponse[buttonId] = true;
      this.adminService
        .faqSectionUpdate(data)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));
            }
            if (res.error) {
              this.toastr.error(this.translate.transform(res.error.errors.message));
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }


  filterValue = "";
  applyFilter(event: Event) {
    this.filterValue = (event.target as HTMLInputElement).value;
    this.searchTerms.next(this.filterValue);
  }

  /** Whether the number of selected elements matches the total number of rows. */
  isAllSelected() {
    const numSelected = this.selection.selected.length;
    let numRows;
    if (this.dataSource) {
        numRows = this.dataSource.data.length;
    }
    return numSelected === numRows;
  }
  /** Selects all rows if they are not all selected; otherwise clear selection. */
  toggleAllRows() {
    if (this.isAllSelected()) {
      this.selection.clear();
      return;
    }

    this.selection.select(...this.dataSource.data);
  }

  /** The label for the checkbox on the passed row */
  checkboxLabel(row?: any): string {
    if (!row) {
      return `${this.isAllSelected() ? 'deselect' : 'select'} all`;
    }
    return `${this.selection.isSelected(row) ? 'deselect' : 'select'} row ${row?.id + 1
      }`;
  }

  createModelPopup(content: any) {
    const modalRef = this.modalService.open(content, { size: 'xl', backdrop: 'static', keyboard: false });
    modalRef.result.then(
      () => {
      },
      () => {
      }
    );
  }
  pagesModel = {
    id: '',
    question: '',
    answer: '',
    faqcatName: '',
    status: '',
    privatemode: '',
  };
  editModelPopup(content: any, row: any) {
    this.pagesModel.id = row.id;
    this.pagesModel.question = row.question;
    this.pagesModel.answer = row.answer;
    this.pagesModel.faqcatName = row.faqcat_id;
    this.pagesModel.status = row.status;
    this.pagesModel.privatemode = row.privatemode;
    const modalRef = this.modalService.open(content, { size: 'xl', backdrop: 'static', keyboard: false });
    modalRef.result.then(
      () => {
        this.pagesModel.id = '';
        this.pagesModel.question = '';
        this.pagesModel.answer = '';
        this.pagesModel.faqcatName = '';
        this.pagesModel.status = '';
        this.pagesModel.privatemode = '';
      },
      () => {
        this.pagesModel.id = '';
        this.pagesModel.question = '';
        this.pagesModel.answer = '';
        this.pagesModel.faqcatName = '';
        this.pagesModel.status = '';
        this.pagesModel.privatemode = '';
      }
    );
  }

  addFaqs(ngForm: any, buttonId) {
    if (ngForm.valid) {
      const data = {

        id: ngForm.value.faq_id,
        question: ngForm.value.question,
        answer: ngForm.value.answer,
        faqcatsname: ngForm.value.faqcat_name,
        status: ngForm.value.status ? ngForm.value.status : 0,
        privatemode: ngForm.value.privatemode ? ngForm.value.privatemode : 0,
      };
      this.sendingResponse[buttonId] = true;
      this.adminService
        .createFaqs(data)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.errors) {
              this.toastr.error(this.translate.transform(res.errors.name));
            }
            if (res.success) {
              this.modalService.dismissAll();
              this.toastr.success(this.translate.transform(res.success));
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }
  editFaqs(ngForm: any, buttonId) {
    if (ngForm.valid) {
      const data = {

        id: ngForm.value.faq_id,
        question: ngForm.value.question,
        answer: ngForm.value.answer,
        faqcatsname: ngForm.value.faqcat_name,
        status: ngForm.value.status ? ngForm.value.status : 0,
        privatemode: ngForm.value.privatemode ? ngForm.value.privatemode : 0,
      };
      this.sendingResponse[buttonId] = true;
      this.adminService
        .createFaqs(data)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.errors) {
              this.toastr.error(this.translate.transform(res.errors.name));
            }
            if (res.success) {
              this.modalService.dismissAll();
              this.toastr.success(this.translate.transform(res.success));
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }
  deleteFaqs(row: any, buttonId) {
    const data = {

      id: row?.id,
    };
    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure ?'),
      text: this.translate.transform('Your will not be able to recover!'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Yes, delete it!'),
      cancelButtonText: this.translate.transform('Close'),
      reverseButtons: true,
    }).then((result: any) => {
      if (result.isConfirmed) {
        this.sendingResponse[buttonId] = true;
        this.adminService
          .deleteFaq(row?.id, data)
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (res) => {
              this.sendingResponse[buttonId] = false;
              if (res.success) {
                this.toastr.success(this.translate.transform(res.success));
              }
            },
            error: () => {
              this.sendingResponse[buttonId] = false;
            },
          });
      }
    });
  }
  massDeletefaqss(buttonId) {
    if (!this.selection.selected.length) {
      this.toastr.error(this.translate.transform('Please select atleast one Faq'));
      return;
    }
    const id: any = [];
    this.selection.selected.map(function (ele) {
      id.push(ele.id);
    });
    const data = {

      id: id,
    };
    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure ?'),
      text: this.translate.transform('Your will not be able to recover!'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Yes, delete it!'),
      cancelButtonText: this.translate.transform('Close'),
      reverseButtons: true,
    }).then((result: any) => {
      if (result.isConfirmed) {
        this.sendingResponse[buttonId] = true;
        this.adminService
          .MassDeleteFaq(data)
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (res) => {
              this.sendingResponse[buttonId] = false;
              this.selection.clear();
              if (res.success) {
                this.toastr.success(this.translate.transform(res.success));
              }
            },
            error: () => {
              this.sendingResponse[buttonId] = false;
            },
          });
      }
    });
  }
  statusUpdate(row, buttonId) {
    const val = row?.status != '1' ? '1' : '0';

    const data = {

      status: val,
    };
    this.sendingResponse[buttonId] = true;
    this.adminService
      .statusFaq(row?.id, data)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.sendingResponse[buttonId] = false;
          if (res.success) {
            this.toastr.success(this.translate.transform(res.success));
          }
        },
        error: () => {
          this.sendingResponse[buttonId] = false;
        },
      });
  }
  privateModeUpdate(row, buttonId) {
    const val = row?.privatemode != '1' ? '1' : '0';

    const data = {

      privatemode: val,
    };
    this.sendingResponse[buttonId] = true;
    this.adminService
      .privatestatusFaq(row?.id, data)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.sendingResponse[buttonId] = false;
          if (res.success) {
            this.toastr.success(this.translate.transform(res.success));
          }
        },
        error: () => {
          this.sendingResponse[buttonId] = false;
        },
      });
  }
  loadData(): Observable<any> {
    this.isloader = true;
    return this.adminService.faqSection(this.paginator.pageIndex + 1, this.paginator.pageSize, this.filterValue).pipe(
      tap((data: any) => {
        this.isloader = false;
        this.dataSource.data = data.queryList.data;
        setTimeout(() => {
          this.paginator.pageIndex = data.queryList.current_page - 1;
          this.paginator.length = data.queryList.total;
          this.paginator.pageSize = data.queryList.per_page;
        });
      }));
  }

  onPaginateTable() {
    this.selection.clear();
    this.loadData().subscribe();
  }

  handleDataFromChild(value: string) {
    this.pagesModel.answer = value;
  }
  override ngOnDestroy() {
    this.modalService?.dismissAll();
  }
  sanitizeHtml(html: string): SafeHtml {
    return this.sanitizer.bypassSecurityTrustHtml(html);
  }
  // this is needed to allow sorting on nested properties
  nestedProperty = (data: any, sortHeaderId: string): string | number => {
    return sortHeaderId
      ?.split('.')
      .reduce((accumulator, key) => accumulator && accumulator[key], data) as
      | string
      | number;
  };
  // this is needed to have caseInsensitive sorting
  caseInsensitive = (data: any, sortHeaderId: string): string | number => {
    const value = data[sortHeaderId];
    return typeof value === 'string' ? value.toUpperCase() :
      value;
  };
  nestedCaseInsensitive = (data: any, sortHeaderId: string): string | number => {
    const value = sortHeaderId
      ?.split('.')
      .reduce((accumulator, key) => accumulator && accumulator[key], data) as
      | string
      | number;
    return typeof value === 'string' ? value.toUpperCase() : value;
  };
}
