import { Component, ElementRef, OnInit, QueryList, ViewChildren } from '@angular/core';
import { takeUntil } from 'rxjs';
import { ToastrService } from 'ngx-toastr';
import { Router } from '@angular/router';
import { TranslatePipe } from '@ngx-translate/core';
import { Unsub } from '../../../../shared/class/unsub.class';
import languagesCodeList from '../../../../shared/data/languagescode';
import { LanguagesService } from '../../../../shared/services/admin/languages.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { NgSelectModule } from '@ng-select/ng-select';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { FormsModule } from '@angular/forms';
@Component({
  selector: 'app-create-language',
  templateUrl: './create-language.component.html',
  styleUrls: ['./create-language.component.scss'],
  standalone : true,
  imports: [AdminPageHeaderComponent, TranslatePipes, NgSelectModule, FormsModule]
})
export class CreateLanguageComponent extends Unsub implements OnInit {
  public sendingResponse: { [key: string]: boolean } = {};
  languagesCodes;
  constructor(
    public languagesService: LanguagesService,
    private toastr: ToastrService,
    private router: Router,
    private translate: TranslatePipe,
    loaderService: LoaderService
  ) {
     /**
     * This code calls the constructor of the parent class in a subclass. 
     * The super() function is used to initialize the parent class and allows access to its properties and methods. 
     * By calling  super(), the subclass can inherit and use the functionality of the parent class.
     **/
super(loaderService);
  }

  ngOnInit(): void {
    this.languagesCodes = languagesCodeList;
  }

  ChangeTheValues(ngForm: any, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const putData = ngForm.value;
      this.languagesService
        .store(putData)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res: any) => {
            this.sendingResponse[buttonId] = false;
            if (res?.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.router.navigate([
                '/admin/languages/translate/' + res.languagecode,
              ]);
            }
            if (res?.error) {
              this.toastr.error(this.translate.transform(res.error));
            }
            if(res?.errors){
              console.log(res?.errors);
              for (const el in res?.errors) {
                if (Array.isArray(res.errors[el])) {
                  for (const msg of res.errors[el]) {
                    this.toastr.error(this.translate.transform(msg));
                  }
                } else {
                  this.toastr.error(this.translate.transform(res.errors[el]));
                }
              }
            }
          },
          error: () => {
             this.sendingResponse[buttonId] = false;
          },
        });
    }
  }

  
  @ViewChildren('filterInput') filterInput!: QueryList<ElementRef>;
  dropdownSearch() {
    this.filterInput.changes.subscribe(res => {
      if(this.filterInput?.first){
        this.filterInput.first.nativeElement.focus()
      }
    })
  }
}
