import { CommonModule } from '@angular/common';
import { Component, EventEmitter, Input, Output, ViewEncapsulation } from '@angular/core';
import { FormsModule } from '@angular/forms';
import { NgbDropdownModule, NgbTooltipModule } from '@ng-bootstrap/ng-bootstrap';
import { emojisData } from '../../../../../shared/data/emojidata';

@Component({
  selector: 'app-emoji',
  standalone: true,
  imports: [CommonModule, FormsModule, NgbDropdownModule, NgbTooltipModule],
  template: `
    <button class="btn-remove-styles" type="button" ngbDropdown (click)="showEmoji($event)">
        <a aria-label="anchor" class="btn-emoji allEmojisBtn no-caret" ngbDropdownToggle
            href="javascript:void(0)" placement="top" container="body" ngbTooltip="Emojis"
            data-bs-original-title="" title="">
            <i class="ri-emotion-line"></i>
        </a>
        <ul ngbDropdownMenu id="emojiGrid" style="height: 200px; overflow-y: scroll;"></ul>
    </button>
`,
encapsulation: ViewEncapsulation.None,
})
export class EmojiComponent {
    @Output() emojiAdded = new EventEmitter<any>();
    constructor(){
        setTimeout(() => {            
            const emojiGrid = document.getElementById("emojiGrid") as HTMLElement;
            // Number of emojis per row
            const emojisPerRow = 8;
            let emojis = [...new Set(emojisData)]

            // Generate emoji grid
            for (let i = 0; i < emojis.length; i++) {
                if (i % emojisPerRow === 0) {
                    // Start a new row
                    const newRow = document.createElement("li");
                    newRow.className = "d-flex";
                    emojiGrid.appendChild(newRow);
                }

                // Create emoji element
                const col = document.createElement("span");
                col.style.padding = "0.5rem"
                col.classList.add("dropdown-item",); // Adjust the grid layout as needed
                col.onclick = ()=>{
                    this.insertEmoji(emojis[i])
                }
                col.innerHTML = `${emojis[i]}`;

                // Append emoji to the current row
                const currentRow = emojiGrid.lastElementChild;
                if(currentRow){
                currentRow.appendChild(col);
                }
            }
        }, 1000);
    }
    showEmoji(event){
        event.preventDefault();
        this.storeRange();
    }
    // store the range
    private storedRange: any;
    storeRange() {
        let message = document.querySelector('#message') as HTMLElement;
        const selection = window.getSelection();
        if(selection?.anchorNode){
            let selected = selection.getRangeAt(0).commonAncestorContainer.parentElement;
            if (selected == message) {
                //storing the range
                this.storedRange = selection.getRangeAt(0);
                return;
            }else{
                let newRng = document.createRange();
                newRng.setStart(message, 0);
                newRng.setEnd(message, 0);
                selection?.removeAllRanges();
                selection?.addRange(newRng);
                this.storedRange = selection?.getRangeAt(0);
                return;
            }
        }
        else{
            const selection = window.getSelection();
            let newRng = document.createRange();
            newRng.setStart(message, 0);
            newRng.setEnd(message, 0);
            selection?.removeAllRanges();
            selection?.addRange(newRng);
            this.storedRange = selection?.getRangeAt(0);
            return;
        }
    }
    retrieveRange() {
        // Used to retrive the stored range value
        if (this.storedRange) {
            return this.storedRange;
        }
    }
    insertEmoji(emoji) {
        let data = {
            "emoji" : emoji,
            "storedRange" : this.storedRange
        }
        this.emojiAdded.emit(data)
    }
}
