import { Component } from '@angular/core';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LiveChatService } from '../../../../shared/services/admin/livechat.service';
import { TranslatePipe } from '@ngx-translate/core';
import { LoaderService } from '../../../../shared/services/loader.service';
import { takeUntil } from 'rxjs';
import { RouterLink } from '@angular/router';
import { FormsModule } from '@angular/forms';
import { CommonModule, DatePipe } from '@angular/common';
import { ToastrService } from 'ngx-toastr';
import Swal from 'sweetalert2';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { NgbTooltipModule } from '@ng-bootstrap/ng-bootstrap';

@Component({
  selector: 'app-chat-responses',
  standalone: true,
  imports: [RouterLink, FormsModule, TranslatePipes, CommonModule, AdminPageHeaderComponent, NgbTooltipModule],
  templateUrl: './chat-responses.component.html',
  styleUrl: './chat-responses.component.scss',
  providers: [DatePipe]
})
export class ChatResponsesComponent extends Unsub {
  data;
  timezone;
  constructor(private adminService: AdminService, private livechatService: LiveChatService, private translate: TranslatePipe, private toastr: ToastrService, loader: LoaderService) {
    super(loader);

  }
  ngOnInit() {
    this.chatResponseFn();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: (res) => {
        this.chatResponseFn();
      },
    });
  }

  chatResponseFn() {
    this.livechatService.chatResponses().subscribe({
      next: res => {
        this.data = res;
        this.timezone = res.timezonedata;
      }
    })
  }


  activeSave(id, status){
    if(id){
      let data = {
        chatId : id,
        checked : status
      }
      this.livechatService.activeChatFlowSave(data).subscribe({
        next : res=>{
          if(res?.sucess){
            this.toastr.success(this.translate.transform(res?.success));
          }
        }
      })
    }
  }

  deleteFlow(id, activeDraft?) {

    if (id) {
      Swal.fire({
        icon: 'warning',
        title: this.translate.transform('Are you sure ?'),
        text: this.translate.transform('Your will not be able to recover!'),
        showCancelButton: true,
        confirmButtonColor: '#6259ca',
        cancelButtonColor: '#f11541',
        confirmButtonText: this.translate.transform('Yes, delete it!'),
        cancelButtonText: this.translate.transform('Close'),
        reverseButtons: true,
      }).then((result: any) => {
        if (result.isConfirmed) {
          if (activeDraft) {
            id = id + activeDraft
          }
          this.livechatService.livechatFlowDelete(id).subscribe({
            next: res => {
              if (res?.success) {
                this.toastr.success(this.translate.transform(res?.success));
              }
            }
          })
        }
      })
    }
  }
}
