import {
  Component,
  inject,
  Renderer2,
  TemplateRef,
  ViewChild
} from "@angular/core";
import { SharedModule } from "../../../../shared/shared.module";
import { Unsub } from "../../../../shared/class/unsub.class";
import Swal from 'sweetalert2';
import { NgbOffcanvas } from "@ng-bootstrap/ng-bootstrap";
import { LoaderService } from "../../../../shared/services/loader.service";
import { ActivatedRoute } from "@angular/router";
import { takeUntil } from "rxjs";
import { LiveChatService } from "../../../../shared/services/admin/livechat.service";
import { TranslatePipes } from "../../../../shared/pipes/translate/translate.pipe";
import { ToastrService } from "ngx-toastr";
import { AdminPageHeaderComponent } from "../../../../shared/common/pageheader/admin-page-header/admin-page-header.component";
// Declare Rete as a global variable
declare var Rete: any;
declare var VueRenderPlugin: any;
declare var TaskPlugin: any;
declare var ContextMenuPlugin: any;
declare var ConnectionPlugin: any;
declare var alertify: any;
declare var AreaPlugin: any;

@Component({
  selector: 'app-livechat-flow',
  standalone: true,
  imports: [SharedModule, TranslatePipes, AdminPageHeaderComponent],
  templateUrl: './livechat-flow.component.html',
  styleUrl: './livechat-flow.component.scss'
})
export class LivechatFlowComponent extends Unsub {
  
  @ViewChild('liveChatOffcanvas') liveChatOffcanvas!: NgbOffcanvas;
  href;
  base;
  private offcanvasService = inject(NgbOffcanvas);
  selectedInput:any = null;
  name = '';
  editorJson = '';
  flow;
  flowChatId;
  constructor(loader: LoaderService, private activedRoute: ActivatedRoute,private renderer: Renderer2, private livechatService: LiveChatService, private translate: TranslatePipes, private toastr: ToastrService ){
    super(loader);
    activedRoute.params.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (params) => {
        this.flowChatId = params['id'];
        this.livechatService.livechatFlow(this.flowChatId).subscribe({
          next: res =>{
            this.flow = res?.flow;
            // this.loadScripts()
            // .then(() => this.initializeReteIfAvailable())
            // .catch(error => console.error('Error loading scripts:', error));
            this.initializeReteIfAvailable();
          }
        })
      }
    });
    this.href = location.origin;
    this.base = document.querySelector('base')?.getAttribute('href');
  }
  private initializeReteIfAvailable() {
    setTimeout(() => {
      if (typeof Rete !== 'undefined') {
        this.initializeRete();
      } else {
        console.error('Rete function is not defined.');
      }
    }, 100); // Slight delay to ensure scripts are fully processed
  }


	open(content: any) {
		this.offcanvasService.open(content, {position: 'end', ariaLabelledBy: 'offcanvas-basic-title' }).result.then(
			(result) => {
        if(result == 'Save click'){
          if(this.selectedInput){
            this.selectedInput.value = this.name;
            this.name  = ''
          }            
        }
			},
			(reason) => {},
		);
	}

  ngOnInit(): void {
    
  }
  // loadScripts(): Promise<void> {
    // const scripts = [
    // ];
    // return Promise.all(scripts.map(src => this.loadScript(src)))
    //   .then(() => Promise.resolve())
    //   .catch(error => Promise.reject(error));
  // }
  
  loadScript(src: string): Promise<void> {
    return new Promise((resolve, reject) => {
      if (document.querySelector(`script[src="${src}"]`)) {
        // Script is already loaded
        resolve();
        return;
      }
      const script = this.renderer.createElement('script');
      script.src = src;
      script.onload = () => resolve();
      script.onerror = () => reject(new Error(`Error loading ${src}`));
      this.renderer.appendChild(document.body, script);
    });
  }
  

  focusTitle(temp){
    if(temp){
      temp.focus();
    temp.click();
    }
  }

  initializeRete(){
    var botAvatar = "https://robohash.org/liberovelitdolores.bmp?size=50x50&set=set1";
    var userAvatar = "http://icons.iconarchive.com/icons/visualpharm/must-have/256/User-icon.png";

    var onMessageTask = [];

    var actSocket = new Rete.Socket("Action");
    var strSocket = new Rete.Socket("String");

    const JsRenderPlugin = {
        install(editor, params = {}) {
            editor.on("rendercontrol", ({
                el,
                control
            }) => {
                if (control.render && control.render !== "js") return;

                control.handler(el, editor);
            });
        }
    };

    class InputControl extends Rete.Control {
        constructor(key) {
            super(key);
            this['render'] = "js";
            this['key'] = key;
        }

        handler(el, editor) {
            var input = document.createElement("input");
            el.appendChild(input);

            var text = this['getData'](this['key']) || "Some message..";

            input.value = text;
            this['putData'](this['key'], text);
            input.addEventListener("change", () => {
                this['putData'](this['key'], input.value);
            });
        }
    }

    class MessageComponent extends Rete.Component {
        constructor() {
            super("Message");
            this['task'] = {
                outputs: {
                    text: "output"
                }
            };
        }

        builder(node) {
            // var inp1 = new Rete.Input("act", "Action", actSocket);
            var out = new Rete.Output("text", "Text", strSocket);
            var out1 = new Rete.Output("act", "Action", actSocket);
            var ctrl = new InputControl("text");

            return node.addControl(ctrl).addOutput(out).addOutput(out1);
        }

        worker(node, inputs,outputs) {
            return {
                text: node.data.text
            };
        }
    }

    class WelComeMessageComponent extends Rete.Component {
        constructor() {
            super("Welcome Message");
            this['task'] = {
                outputs: {
                    text: "output"
                }
            };
        }

        builder(node) {
            // var out = new Rete.Output("text", "Text", strSocket);
            var out1 = new Rete.Output("act", "Action", actSocket);
            var ctrl = new InputControl("text");

            return node
                .addControl(ctrl)
                .addOutput(out1)
        }

        worker(node, inputs) {
            return {
                text: node.data.text
            };
        }
    }

    class OptionComponent extends Rete.Component {
        constructor() {
            super("Option");
            this['task'] = {
                outputs: {
                    act: "option",
                },
                init(task:never){
                    onMessageTask.push(task);
                }
            };
        }

        builder(node) {
            var inp1 = new Rete.Input("act", "Action", actSocket);
            var ctrl = new InputControl("optionName");
            var inp2 = new Rete.Input("text", "Text", strSocket);


            return node.addControl(ctrl).addInput(inp1).addInput(inp2);
        }
        worker(node, inputs, outputs) {
          return {
            text: inputs["text"] ? inputs["text"][0] : node.data.text
          } 
            // var text = inputs["text"] ? inputs["text"][0] : node.data.text;
        }
    }

    var components = [
        // new MessageSendComponent(),
        new MessageComponent(),
        new WelComeMessageComponent(),
        new OptionComponent()
    ];

    var container = document.getElementById("editor");    
    var editor = new Rete.NodeEditor("demo@0.1.0", container);
    
    editor.use(VueRenderPlugin.default);
    editor.use(ConnectionPlugin.default);
    editor.use(ContextMenuPlugin.default);
    editor.use(JsRenderPlugin);
    editor.use(TaskPlugin);

    var engine = new Rete.Engine("demo@0.1.0");

    components.forEach(c => {
        editor.register(c);
        engine.register(c);
    });

    // To add the Created Chat Id
    let autosaveId = "null"

    editor
        .fromJSON(
          this.flow?.liveChatFlow ? JSON.parse(this.flow?.liveChatFlow) :
            {
                "id": "demo@0.1.0",
                "nodes": {
                    "1": {
                        "id": 1,
                        "data": {
                            "text": "Welcome to the Chatbot! How can I assist you today?"
                        },
                        "inputs": {},
                        "outputs": {
                            "act": {
                                "connections": [{
                                    "node": 2,
                                    "input": "act",
                                    "data": {}
                                }]
                            }
                        },
                        "position": [-333, -586],
                        "name": "Welcome Message"
                    },
                    "2": {
                        "id": 2,
                        "data": {
                            "optionName": "Sales"
                        },
                        "inputs": {
                            "act": {
                                "connections": [{
                                    "node": 1,
                                    "output": "act",
                                    "data": {}
                                }]
                            },
                            "text": {
                                "connections": [{
                                    "node": 3,
                                    "output": "text",
                                    "data": {}
                                }]
                            }
                        },
                        "outputs": {},
                        "position": [296, -545],
                        "name": "Option"
                    },
                    "3": {
                        "id": 3,
                        "data": {
                            "text": "Hello World"
                        },
                        "inputs": {},
                        "outputs": {
                            "text": {
                                "connections": [{
                                    "node": 2,
                                    "input": "text",
                                    "data": {}
                                }]
                            },
                            "act": {
                                "connections": []
                            }
                        },
                        "position": [-8, -366],
                        "name": "Message"
                    }
                }
            }
        )
        .then(() => {

            editor.on("error", err => {
                alertify.error(err.message);
            });

            editor.on("process connectioncreated connectionremoved nodecreated", async function(data) {
                    if (engine.silent) return;
                    onMessageTask = [];
                    await engine.abort();
                    await engine.process(editor.toJSON());
                }
            );
            editor.on('connectionpick', async function(data) {
                    // when changing options remove the focus
                    let ele = document.querySelector('.node.welcome-message')?.querySelector('input');
                    if(ele){
                      ele.focus();
                      ele.blur()
                    }
            })
            let seletedPopup = true;
            editor.on('selectnode',async (data) => {
              if (data.e.button === 0) {
                if(seletedPopup && data.e.target?.nodeName?.toLowerCase() == "input"){
                    if (this.liveChatOffcanvas) {
                      if(data.node.name != "Option"){
                        this.name = data.node.data.text;
                        this.selectedInput =  data.e.target.closest('.node').querySelector("input");     
                        setTimeout(()=>{(document.querySelector('#exampleFormControlTextarea1') as HTMLTextAreaElement)?.focus();}, 500)
                        this.selectedInput.value = this.name;
                      }else{
                        this.name = data.node.data.optionName;
                        this.selectedInput =  data.e.target.closest('.node').querySelector("input");
                        setTimeout(()=>{(document.querySelector('#exampleFormControlTextarea1') as HTMLTextAreaElement)?.focus();}, 500)
                        this.selectedInput.value = this.name;
                      }
                      this.offcanvasService.open(this.liveChatOffcanvas, {position: 'end', ariaLabelledBy: 'offcanvas-basic-title' }).result.then(
                        (result) => {
                          if(result == 'Save click'){
                            if(this.selectedInput){
                              if(data.node.data?.['text']){
                                data.node.data['text'] = this.name;
                              }
                              if(data.node.data?.['optionName']){
                                data.node.data['optionName'] = this.name;
                              }
                              this.selectedInput.value = this.name;
                              this.name  = ''
                            }            
                          }
                        },
                        (reason) => {},
                      );
                    }
                }
              }
            })
            editor.on('nodetranslate',async function(data){
                seletedPopup = false
                setTimeout(() => {
                    seletedPopup = true
                }, 200);
            })
            // To remove the contextmenu From the WelCome Message
            editor.nodes.forEach((node)=>{
                if(node.name == "Welcome Message"){
                    node.vueContext.$el.addEventListener('contextmenu',(event)=>{
                        event.preventDefault();
                        event.stopPropagation();
                    })
                }
            })
            editor.on('contextmenu',async function(data){
              
                setTimeout(() => {
                    const items = document.querySelectorAll('.context-menu .item');
                    let welcomeMessageDiv:any = null;
                    items.forEach((item:any) => {
                        if (item.textContent.trim() === 'Welcome Message') {
                            welcomeMessageDiv = item;
                        }
                    });
                    welcomeMessageDiv?.classList.add("d-none")
                }, 10);
                seletedPopup = false
                setTimeout(() => {
                    seletedPopup = true
                }, 200);
            })
            let denouncing
            editor.on('connectioncreated connectionremoved nodecreated keyup', async (data)=>{
                // For the Auto Save
                if(denouncing){ 
                  clearTimeout(denouncing)
                }

                // if({!! json_encode($flowChatId) !!} == 'null' && autosaveId == 'null'){
                  if(document.querySelector("#liveChatFlowBtn")){
                    (document.querySelector("#liveChatFlowBtn") as HTMLButtonElement).disabled = true
                  }
                // }

                denouncing = setTimeout(()=>{
                  this.editorJson = JSON.stringify(editor.toJSON());                  
                    let AutoSaveData = {
                        chatId : this.flowChatId,
                        chat : JSON.stringify(editor.toJSON()),
                        responseName : document.querySelector('.responseFlowName')?.['innerText']
                    }

                    document.querySelector(".autoSavedSpiner .spinner4")?.classList.remove("d-none")
                    document.querySelector(".autoSavedSpiner b")?.classList.add("d-none")
                    this.livechatService.ChatAutoFlowSave(AutoSaveData).subscribe({
                      next: res=>{
                        document.querySelector(".autoSavedSpiner .spinner4")?.classList.add("d-none")
                            document.querySelector(".autoSavedSpiner b")?.classList.remove("d-none")
                            if(autosaveId == "null"){
                                autosaveId = res.success.id;
                                this.flowChatId = res.success.id;                                
                            }
                            (document.querySelector("#liveChatFlowBtn") as HTMLButtonElement).disabled = false
                      },
                      error : err =>{}
                    })
                },5000)
            })

            editor.trigger("process");
            editor.view.resize();
            AreaPlugin.zoomAt(editor);
        });
    
    
  }

  tryItOut(flowChatId){
    // window.open(`http://192.168.0.117/Uhelp_angular3.0/admin/live-chat/test-it-out/${flowChatId}","Ratting","width=850,height=700,0,status=0,scrollbars=1`);
    
    localStorage.removeItem("LiveChatCust")
    const url = `${this.href}${this.base}/admin/live-chat/test-it-out/${flowChatId}`;
    window.open(url, '_blank', 'width=850,height=700,0,status=0,scrollbars=1');
  }

  activateLiveChat(){
    
    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure you want to continue?'),
      text: this.translate.transform('This Flow will maked was default'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Activate'),
      cancelButtonText: this.translate.transform('Cancle'),
      reverseButtons: true,
    }).then((result: any) => {
      if (result.isConfirmed) {
        let AutoSaveData = {
        // chatId  : {!! json_encode($flowChatId) !!} != 'null' ? {!! json_encode($flowChatId) !!} : autosaveId,
        chatId : this.flowChatId,
        chat : this.editorJson,
        responseName : document.querySelector('.responseFlowName')?.['innerText']
    }
        this.livechatService.ChatFlowSave(AutoSaveData)
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (res) => {
              if (res.success) {
                this.toastr.success(this.translate.transform(res.success));
                              document.querySelector(".autoSavedSpiner .spinner4")?.classList.add("d-none");
                              document.querySelector(".autoSavedSpiner b")?.classList.remove("d-none");
                              (document.querySelector("#liveChatFlowBtn") as HTMLButtonElement).disabled = false
           
              }
            },
            error: () => {
            },
          });
      }
    });
  }
}