import { Routes } from '@angular/router';

export const liveChatRouting: Routes = [

  {
    path: 'new-chats', loadComponent: () => import('./newcharts/newcharts.component').then(e => e.NewchartsComponent), data: {
      permission: "Customer Chat Process"
    }
  },
  {
    path: 'chart-flow/:id', loadComponent: () => import('./livechat-flow/livechat-flow.component').then(e => e.LivechatFlowComponent), data: {
      permission: "Chat Flows"
    }
  },
  {
    path: 'my-open-chats', loadComponent: () => import('./my-opened-charts/my-opened-charts.component').then(e => e.MyOpenedChartsComponent), data: {
      permission: "Customer Chat Process"
    }
  },
  {
    path: 'solved-chats', loadComponent: () => import('./solved-charts/solved-charts.component').then(e => e.SolvedChartsComponent), data: {
      permission: "Customer Chat Process"
    }
  },
  {
    path: 'operators', loadComponent: () => import('./operators/operators.component').then(e => e.OperatorsComponent), data: {
      permission: 'Operators'
    }
  },
  {
    path: 'chat-flow', loadComponent: () => import('./chat-responses/chat-responses.component').then(e => e.ChatResponsesComponent), data: {
      permission: true
    }
  },
  {
    path: 'live-chat-settings', loadComponent: () => import('./livechat-settings/livechat-settings.component').then(e => e.LivechatSettingsComponent), data: {
      permission: "Livechat Settings"
    }
  },
  {
    path: 'live-chat-ratings', loadComponent: () => import('./livechat-ratings/livechat-ratings.component').then(e => e.LivechatRatingsComponent), data: {
      permission: "Livechat Ratings"
    }
  },
  {
    path: 'notification-sounds', loadComponent: () => import('./notification-sounds/notification-sounds.component').then(e => e.NotificationSoundsComponent), data: {
      permission: "Livechat Settings"
    }
  },
  {
    path: 'livechat-agent-report-details/:id', loadComponent: () => import('./livechat-agent-report-details/livechat-agent-report-details.component').then(e => e.LivechatAgentReportDetailsComponent), data: {
      permission: true
    }
  },
  {
    path: 'livechatTickets/:id', loadComponent: () => import('./livechat-tickets/livechat-tickets.component').then(e => e.LivechatTicketsComponent), data: {
      permission: true
    }
  },
];