import { CommonModule } from '@angular/common';
import {
  ChangeDetectorRef,
  Component,
  ElementRef,
  ViewChild,
} from '@angular/core';
import {
  NgbDropdownModule,
  NgbModal,
  NgbModalModule,
  NgbTooltipModule,
} from '@ng-bootstrap/ng-bootstrap';
import { NgSelectModule } from '@ng-select/ng-select';
import {
  FormsModule,
  ReactiveFormsModule,
  FormGroup,
  FormControl,
  NgForm,
} from '@angular/forms';
import { RouterLink, ActivatedRoute, Router, NavigationStart } from '@angular/router';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { debounceTime, Observable, Subject, Subscription, switchMap, takeUntil, timer } from 'rxjs';
import Swal from 'sweetalert2';
import { NgSelectInputComponent } from '../../../../core/components/input/ng-select-input/ng-select-input.component';
import { TextareaInputComponent } from '../../../../core/components/input/textarea-input/textarea-input.component';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LiveChatService } from '../../../../shared/services/admin/livechat.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { AgentMessageComponent } from '../chat-interface/agent-message/agent-message.component';
import { CommentMessageComponent } from '../chat-interface/comment-message/comment-message.component';
import { CustomerMessageComponent } from '../chat-interface/customer-message/customer-message.component';
import { EmojiComponent } from '../chat-interface/emoji/emoji.component';
import { FeedbackCommentComponent } from '../chat-interface/feedback-comment/feedback-comment.component';
import { Unsub } from '../../../../shared/class/unsub.class';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { DateAgoPipe } from '../../../../shared/pipes/date-ago/date-ago.pipe';
import { LivechatViewComponent } from '../chat-interface/livechat-view/livechat-view.component';
import { LivechatSocketService } from '../../../../shared/services/livechat-socket.service';
import { LivechatDataService } from '../../../../shared/services/livechat-data.service';
import { OperatorschatDataService } from '../../../../shared/services/operatorschat-data.service';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';

@Component({
  selector: 'app-operators',
  standalone: true,
  imports: [
    CommonModule,
    FormsModule,
    ReactiveFormsModule,
    RouterLink,
    TranslatePipes, DateAgoPipe,
    NgbDropdownModule,
    NgSelectInputComponent,
    NgbModalModule,
    AdminPageHeaderComponent,
    NgbTooltipModule,
    NgSelectModule,
    EmojiComponent
  ],
  templateUrl: './operators.component.html',
  styleUrl: './operators.component.scss',
})
export class OperatorsComponent extends Unsub {
  @ViewChild('chatReplyInput', { static: false }) chatReplyInput!: ElementRef;
  private typingSubject = new Subject<string>();
  public sendingResponse: { [key: string]: boolean } = {};
  private debounceTimeout = 500; // Debounce time in milliseconds
  data;
  // unique_id;
  details;
  cannedmessages;
  allActiveUsers= [];
  pastMessage = '';
  newVal = '';
  subscategory = null;
  today;
  reply = '';
  user;
  users;
  isChat = true;
  settings;
  userRole;
  OperatorData  =[];
  receiverdata;
  senderdata;
  receiverUsersInfo;
  groupData;
  id = null;
  currentDate = "";
  type;
  autoUserInfo;
  AuthId;
  customerData;
  parsedChatFlowMessages: any[] = [];
  chatData;
  operatorUser: any = null;
  chatOpenAgent = [];
  formatTime;
  timezone;
  typingList = [];
  constructor(
    private liceChatService: LiveChatService,
    private el: ElementRef,
    private adminService: AdminService,
    private activatedRoute: ActivatedRoute,
    private translate: TranslatePipe,
    private toastr: ToastrService,
    private router: Router,
    private modalService: NgbModal,
    private LivechatSocketService: LivechatSocketService,
    private OperatorschatDataService: OperatorschatDataService,
    private cdr: ChangeDetectorRef,
    loaderService: LoaderService,
  ) {
    super(loaderService);
    

    this.today = this.formatDateString();
    this.autoUserInfo = localStorage.getItem('user')
      ? JSON.parse(localStorage.getItem('user') as string)
      : null;
    this.activatedRoute.queryParams
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (params: any) => {
          this.customerData = null;
          this.chatData = null;
          this.parsedChatFlowMessages = [];
          this.operatorUser = null;
          this.id = params.operatorID ?? params.groupId;
          this.type = params.operatorID ? 'operator' : params.groupId ? 'group' : '';
          this.formatTime = this.LivechatSocketService.formatTime;
          this.reAssign.get('custId')?.patchValue(this.id);
          this.operatorsChatFn();
          this.adminService.RefreshRquestAdmin$.pipe(
            takeUntil(this.unSubscribe$)
          ).subscribe({
            next: () => {
              this.operatorsChatFn();
            },
          });
        },
      });
      
    this.typingSubject.pipe(
      debounceTime(this.debounceTimeout),
      switchMap((typingMessage) => {
        return this.sendTypingMessage(typingMessage);
      })
    ).subscribe(
      (data) => {
      },
      (error) => {
      }
    );

    this.router.events.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (event: any) => {
        if (event instanceof NavigationStart) {
            this.typingList = [];
            this.OperatorschatDataService.clearWriting();
          }
        }
      })
  }

  ngOnInit() {
  
    this.OperatorschatDataService.data$.subscribe({
      next : res =>{        
        this.typingList = res.writing.filter(e => e.groupInclude ? e.id == this.id : e.userId == this.id && e.id == this.AuthId );
        this.typingList.map(e =>{
          if(e.typing){
            timer(5000).subscribe(() => {
              e.typing = false;
              this.cdr.markForCheck();
            });
          }
        })
        let liveChatConversation = document.querySelector("#operator-conversation") as HTMLElement;
        if(liveChatConversation){
          liveChatConversation.scrollTop = liveChatConversation.scrollHeight;
        }
      }
    })
  }
  updateemojiAdded(event) {
    const textNode1 = document.createTextNode(event.emoji);
    event.storedRange?.insertNode(textNode1);
    let selection = window.getSelection();
    if (event.storedRange?.commonAncestorContainer.textContent) {
      this.newVal = event.storedRange.commonAncestorContainer.textContent;
      setTimeout(() => {
        let newRng = document.createRange();
        newRng.setStartAfter(textNode1);
        newRng.setEndAfter(textNode1);
        selection?.removeAllRanges();
        selection?.addRange(newRng);
      }, 100);
    }
  }
  UploadedImages: string[] = [];
  fileUpload() {
    // conversation Image Upload
    let liveChatFileUpload = this.settings.liveChatFileUpload,
      livechatMaxFileUpload = this.settings.AgentlivechatMaxFileUpload,
      livechatFileUploadMax = this.settings.AgentlivechatFileUploadMax,
      livechatFileUploadTypes = this.settings.AgentlivechatFileUploadTypes;

    var fileInput = document.querySelector('#chat-file-upload') as HTMLInputElement;
    var file: any = fileInput.files?.[0];
    fileInput.value = '';
    var ThereIsError: any = false;

    // For check the File Upload permissions
    if (livechatMaxFileUpload <= this.UploadedImages?.length) {
      ThereIsError = {
        errorMessage: 'The maximum file upload limit has been exceeded.',
      };
    } else if (file.size > parseInt(livechatFileUploadMax) * 1024 * 1024) {
      ThereIsError = {
        errorMessage: `File size exceeds ${livechatFileUploadMax} MB. Please choose a smaller file.`,
      };
    } else if (
      livechatFileUploadTypes &&
      !livechatFileUploadTypes
        .split(',')
        .some((ext) =>
          file.name
            .toLowerCase()
            .toLowerCase()
            .endsWith(ext.toLowerCase().trim())
        )
    ) {
      ThereIsError = {
        errorMessage: `Invalid file extension. Please choose a file with ${livechatFileUploadTypes} extension(s).`,
      };
    } else {
      ThereIsError = false;
    }
    // Upload The File
    if (file && !ThereIsError) {
      var formData = new FormData();
      formData.append('chatFileUpload', file);
      this.liceChatService.liveChatImageUpload(formData).subscribe({
        next: (res) => {
          this.UploadedImages.push(res.image);
        },
      });
    } else {
      this.toastr.error(ThereIsError.errorMessage);
    }
  }
  imageRemoveClick(event, image) {
    let target = event.target;
    let ele = target.closest('.file-img');
    let data = {
      filename: image,
    };
    this.liceChatService.liveChatImageRemove(data).subscribe({
      next: (res) => {
        let indexOfEle = this.UploadedImages?.indexOf(image);
        this.UploadedImages?.splice(indexOfEle, 1);
      },
    });
  }
  operators$: Subscription;
  operatorsChatFn() {
    this.loaderService.showLoader();
    // this.isloader = true;
    this.operators$ = this.liceChatService
      .operators()
      .subscribe({
        next: (res) => {
          this.AuthId = res.userId;
          // this.unique_id = res.unique_id;
          if (!this.chatOpenAgent.includes(this.AuthId) && !isNaN(Number(this.AuthId))){
            this.chatOpenAgent.push(Number(this.AuthId));
          }
          this.timezone = res.timezonedata;
      
          this.selectedUsersArray.push(this.AuthId);
          if (this.data != res) {
            this.data = res;
            if(this.data.allconver){
              this.data.allconver = Object.values(this.data.allconver);
            }
          }
          this.cannedmessages = res.cannedmessages;
          this.user = res.user;
          this.users = res.user;
          this.reply = '';
          this.newVal = '';
          this.settings = res.settings;
          if (this.type == 'operator') {
            this.sideMenuOpenClickFunction(this.id);
          }else if(this.type == 'group'){
            this.groupOpenClickFunction(this.id);
          }
        },
      });
  }
  livechatOperatorConversationDelete(id) {
    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure you want to continue?'),
      text: this.translate.transform('This conversation will be deleted'),
      showCancelButton: true,
      confirmButtonColor: '#e64942',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Delete'),
      cancelButtonText: this.translate.transform('Cancle'),
      reverseButtons: true,
      customClass: {
        confirmButton: 'custom-confirm-button',
        cancelButton: 'custom-cancel-button',
      },
    }).then((result: any) => {
      if (result.isConfirmed) {
        if(this.type == 'group'){
          this.liceChatService.operatorsGroupconversiondelete(id).pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (res) => {
              this.toastr.success(this.translate.transform(res.success));
              this.customerData = null;
              this.chatData = null;
              this.parsedChatFlowMessages = [];
              this.operatorUser = null;
            },
            error: () => {},
          });
        }else if(this.type == 'operator'){
          this.liceChatService
            .operatorsConversationdelete(id)
            .pipe(takeUntil(this.unSubscribe$))
            .subscribe({
              next: (res) => {
                this.toastr.success(this.translate.transform(res.success));
                this.customerData = null;
                this.chatData = null;
                this.parsedChatFlowMessages = [];
                this.operatorUser = null;
              },
              error: () => {},
            });
          
        }
      }
    });
  }
  livechatOperatorGroupconversiondelete(id) {    
    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure you want to continue?'),
      text: this.translate.transform('This conversation will be deleted'),
      showCancelButton: true,
      confirmButtonColor: '#e64942',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Delete'),
      cancelButtonText: this.translate.transform('Cancle'),
      reverseButtons: true,
      customClass: {
        confirmButton: 'custom-confirm-button',
        cancelButton: 'custom-cancel-button',
      },
    }).then((result: any) => {
      if (result.isConfirmed) {
        this.liceChatService
          .operatorsGroupconversiondelete(id)
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (res) => {
              this.toastr.success(this.translate.transform(res.success));
              this.customerData = null;
              this.chatData = null;
              this.parsedChatFlowMessages = [];
              this.operatorUser = null;
            },
            error: () => {},
          });
      }
    });

  }
  unique_id = undefined;
  // SideBar and Online operators loop click
  sideMenuOpenClickFunction(id) {
    
    this.liceChatService.operatorsSingleoperator(id).subscribe({
      next: (data) => {
        this.details = data;
        if(!this.details?.userconversation){
          this.details.created_at = new Date();
        }
        this.OperatorData = data?.userconversation ?? [];
        this.unique_id = data.unique_id;
        this.senderdata = data?.senderdata;
        this.receiverdata = data?.receiverdata;  
      },
      error: (err) => {},
    });
  }
  groupOpenClickFunction(id) {
    this.liceChatService.operatorsGroupconversion(id).subscribe({
      next: (data) => {     
        this.OperatorData = data?.livechatdata ?? [];
        this.unique_id = data.unique_id;
        this.receiverUsersInfo = data?.receiverUsersInfo; 
        this.receiverdata = data?.receiverUsersInfo;      
      },
      error: (err) => {},
    });
  }
  formatString(inputString) {
    // Remove single quotes and split the string by commas
    var parts = inputString?.replace(/'/g, '').split(',');

    // Trim each part and join them with a comma and space
    var result = parts?.map(function(part) {
        return part.trim();
    }).join(', ');

    return result;
}
  groupConservationId(groupId, operatorId){
    this.router.navigate([], {
      relativeTo: this.activatedRoute,
      queryParams: { groupId: groupId, operatorID : operatorId  },
      queryParamsHandling: 'merge' // Merge with existing query params
    });
    // this.liceChatService.operatorsGroupconversion(id).subscribe({
    //   next: res =>{
    //     this.customerData = res.livechatdata;     
    //   }
    // })    
  }
  labelStatus = true;
  formatDateString(inputDateStr?) {
    
    const inputDate = inputDateStr ? new Date(inputDateStr) : new Date();
    const monthNames = [
      'Jan',
      'Feb',
      'Mar',
      'Apr',
      'May',
      'Jun',
      'Jul',
      'Aug',
      'Sep',
      'Oct',
      'Nov',
      'Dec',
    ];
    const year = inputDate.getFullYear();
    const month = monthNames[inputDate.getMonth()];
    const day = inputDate.getDate();
    const formattedDate = `${day},${month} ${year}`;
    if(inputDateStr){
      if(this.currentDate.length && this.currentDate != formattedDate){
        this.labelStatus = false;
      }else{
        this.labelStatus = true;
      }
      this.currentDate = formattedDate;
    }
    
    return formattedDate;
  }
  updateValue(val) {
  }
  parse(val) {
    if (val) {
      return JSON.parse(val);
    }
    return [];
  }

  reAssign = new FormGroup({
    custId: new FormControl(this.id ?? null),
  });
  cannedRes = new FormGroup({
    custId: new FormControl(this.id ?? null),
  });

  reAssignUserFn(name, main) {
    if (name.valid) {
      let formData = new FormData();
      for (const key in name.value) {
        formData.append(key, name.value[key]);
      }
      formData.append('custId', this.id);
      this.liceChatService[main](formData).subscribe({
        next: (res) => {
          this.modalService.dismissAll();
          this.customerData = null;
          this.chatData = null;
          this.parsedChatFlowMessages = [];
          this.operatorUser = null;
          this.router.navigateByUrl('/admin/live-chat/new-chats');
        },
      });
    }
  }
  convertToCommaSeparated(val) {
    let array;

    // Check if the input is already an array
    if (Array.isArray(val)) {
        array = val;
    } else if (typeof val === 'string') {
        try {
            // Safely parse the string to a JavaScript array
            array = JSON.parse(val);

            // Ensure the parsed value is indeed an array
            if (!Array.isArray(array)) {
                throw new Error('Parsed value is not an array');
            }
        } catch (e) {
          return val;
        }
    } else {
      return val;
    }

    // Convert array to a comma-separated string
    return array.join(',');
}
onEnterKey(event: KeyboardEvent, form: NgForm) {
  if (event.shiftKey) {
    // Allow new line for Shift + Enter
    return;
  }

  // Prevent default Enter behavior and submit the form
  event.preventDefault();
  if (form.valid) {
    this.chatReplyUserFn(form, 'livechatConversationReassign');
  }
}
  chatReplyUserFn(ngForm, holderId) {  
    this.sendingResponse[holderId] = true;
    if(this.type == "operator"){
      if(this.newVal){
        let data = {
        message: this.newVal,
        receiverId: this.id,
        messageStatus:  `sent`,
        };
        this.liceChatService.operatorsBroadcastoperator(data).subscribe({
          next: (res) => {            
            this.sendingResponse[holderId] = false;
            this.chatReplyInput.nativeElement.textContent = '';
            this.liceChatService.operators();
            this.newVal = '';
          },
          error : err => this.sendingResponse[holderId] = false
        });
      }
      if(this.UploadedImages.length){
        this.UploadedImages.forEach((ele) => {
          let data = {
            message: ele,
            receiverId: this.id,
            messageStatus:  `sent`,
            messageType: 'image',
          };
          this.liceChatService.operatorsBroadcastoperator(data).subscribe({
            next: (res) => {
              this.sendingResponse[holderId] = false;
              let indexOfEle = this.UploadedImages?.indexOf(ele);
              this.UploadedImages?.splice(indexOfEle, 1);
            },
            error : err => this.sendingResponse[holderId] = false
          });
        });
      }
    }else{    
      this.chatOpenAgent = [...this.chatOpenAgent, this.AuthId];
      const seenUsersIds = [this.AuthId]
      
      if(this.newVal){
        let formData:any = new FormData();
        formData.append("message", this.newVal);
        formData.append("recieverUsersNames", document.querySelector("#operator-conversation")?.getAttribute('group-recievers_names'));
        formData.append("usersId", JSON.stringify(document.querySelector("#operator-conversation")?.getAttribute('group-recievers_id')?.split(',')?.map(item => Number(item))));
        formData.append("messageStatus", 'sent');
        formData.append("seenUserIds", `[${seenUsersIds}]`);
        this.liceChatService.operatorsGroupconversionstore(this.id, formData).subscribe({
          next: (res) => {
            this.newVal = null
            this.chatReplyInput.nativeElement.textContent = '';
            this.sendingResponse[holderId] = false;
          },
          error : err => this.sendingResponse[holderId] = false
        });
      }
      
      if(this.UploadedImages.length){
        this.UploadedImages.forEach((ele) => {
          let data = {
            message: ele,
            recieverUsersNames : document.querySelector("#operator-conversation")?.getAttribute('group-recievers_names'),
            usersId : JSON.stringify(document.querySelector("#operator-conversation")?.getAttribute('group-recievers_id')?.split(',')?.map(item => Number(item))),
            messageType: 'image',
            messageStatus: 'sent',
            seenUserIds: `[${seenUsersIds}]`,
          };
          this.liceChatService.operatorsGroupconversionstore(this.id, data).subscribe({
            next: (res) => {
              let indexOfEle = this.UploadedImages?.indexOf(ele);
              this.UploadedImages?.splice(indexOfEle, 1);
              this.sendingResponse[holderId] = false;
            },
            error : err => this.sendingResponse[holderId] = false
          });
        });
      }
    }
  }
  

  openAssignModel(content) {
    const modalRef = this.modalService.open(content, {
      size: 'lg', backdrop: 'static', keyboard: false
    });
    modalRef.result.then(
        () => {    
          this.selectedUsersArray = [this.AuthId];
          this.selectedUsersNamesArray = [];
          this.selectAll = false;
        },
        () => {    
          this.selectedUsersArray = [this.AuthId];
          this.selectedUsersNamesArray = [];
          this.selectAll = false;
        }
    );
  }
  
  conversationLeave(id) {
    this.liceChatService.livechatConversationleave(id).subscribe({
      next: (res) => {
        if (res?.success) {
          this.toastr.success(this.translate.transform(res.success));
        }
      },
    });
  }
  removeUserFromUnread(id) {
    this.liceChatService.livechatRemoveUserFromUnread(id).subscribe({
      next: (res) => {
        if (res?.success) {
          this.toastr.success(this.translate.transform(res.success));
        }
      },
    });
  }
  conversationUnread(id) {
    this.liceChatService.livechatConversationUnread(id).subscribe({
      next: (res) => {
        if (res?.success) {
          this.toastr.success(this.translate.transform(res.success));
        }
      },
    });
    localStorage.removeItem('livechatCustomer');
  }
  markAsSolved(id) {
    this.liceChatService.livechatMarkSolved(id).subscribe({
      next: (res) => {
        if (res?.success) {
          this.toastr.success(this.translate.transform(res.success));
          this.router.navigate([`/admin/live-chat/solved-chats`], {
            queryParams: { id: res?.id },
          });
        }
      },
    });
  }
  markAsRead(id) {
    this.liceChatService.operatorsMarkasread(id).subscribe({
      next: (res) => {
        if (res?.success) {
          this.toastr.success(this.translate.transform(res.success));
        }
      },
    });
  }
  markAsUnRead(id) {
    this.liceChatService.operatorsMarkasunread(id).subscribe({
      next: (res) => {
        if (res?.success) {
          this.toastr.success(this.translate.transform(res.success));
        }
      },
    });
  }
  
  selectAll: boolean = false;
  selectedUsersArray = [];
  selectedUsersNamesArray = [];
  selectUser(event: Event) {
    let target = event.target as HTMLInputElement;
    var dataId = target?.closest('li').getAttribute('data-id');
    var usersName = target?.closest('li').querySelector('.font-weight-semibold')?.['innerText'];
    if(target.checked){
      if(!this.selectedUsersArray.includes(Number(dataId))){
        this.selectedUsersArray.push(Number(dataId));
        this.selectedUsersNamesArray.push(usersName);
      }
    }else{
      if(this.selectedUsersArray.includes(Number(dataId))){
        this.selectedUsersArray = this.selectedUsersArray.filter(value => value != Number(dataId));
        this.selectedUsersNamesArray = this.selectedUsersNamesArray.filter(value => value != usersName);
      }
    }
    // Update selectAll based on all checkboxes being checked or not
    this.updateSelectAll();
  }
  toggleSelectAll(checked: boolean) {
    this.selectedUsersArray = [this.AuthId];
    this.selectedUsersNamesArray = [];
    if(checked){
      this.user.forEach(user => {
        this.selectedUsersArray.push(user.id);
        this.selectedUsersNamesArray.push(user.name);
      })
    }
  }
  createNewRoom(){
    let data = {
      'usersId': JSON.stringify(this.selectedUsersArray),
      'recieverUsersNames': this.selectedUsersNamesArray.map(item => `'${item}'`).join(', ')
    }    
    this.liceChatService.operatorsGroupbroadcastoperator(data).subscribe({
      next : res =>{
        this.modalService.dismissAll();        
        this.selectedUsersArray = [this.AuthId];
        this.selectedUsersNamesArray = [];
        this.selectAll = false;
      }
    })
  }
  updateSelectAll() {
    const allSelected = this.user.every(user => this.selectedUsersArray.includes(user.id));
    this.selectAll = allSelected;
  }
  

  sendTypingMessage(typingMessage: string): Observable<any> {
    const data = {
      message: null,
      receiverId: document.querySelector("#operator-conversation").getAttribute(
          'operator-id') ? document.querySelector("#operator-conversation").getAttribute(
              'operator-id') : document.querySelector("#operator-conversation").getAttribute(
              'operator-id'),
      typingMessage:typingMessage
    };
    return this.liceChatService.operatorsAgentbroadcastmessagetyping(data);
  }
  onSelectChange(value) {
    let newVal = value.messages?.trim();
    if (newVal == this.newVal) return;
    if (this.chatReplyInput) {
      this.chatReplyInput.nativeElement.innerHTML = newVal;
    }
    this.reply = newVal;
    this.newVal = newVal;
    this.modalService.dismissAll();
  }
  onTextareaValueChange(value) {
    this.newVal = value || '';    
    this.typingSubject.next(this.newVal);
  }

  fileUploadPermission(event, val) {
    let ele = event.target;

    let data = {
      permission: ele.checked,
      custUser: val?.id,
    };
    this.liceChatService.livechatLiveChatCustFileupload(data).subscribe({
      next: (res) => {
      },
    });
  }
  
  updatemenu(value){
    let customerIdEle: HTMLElement = this.el.nativeElement.querySelector(`.checkforactive[data-id='${value}']`);
    customerIdEle?.classList.add("moveout");
  }

  getEncodedMessage(val): string {
    // Split the URL into base URL and filename
    const baseUrl = val.substring(0, val.lastIndexOf('/') + 1);
    const filename = val.substring(val.lastIndexOf('/') + 1);

    // Encode only the filename part
    const encodedFilename = encodeURIComponent(filename);
    // Combine the base URL with the encoded filename
    let url = baseUrl + encodedFilename;
    return "'" + url + "'";
  }
  getUploadExe(value){
    if (!value) return '';
      
      const fileName = value.split('/').pop(); // Get the last part after /
      if (!fileName) return '';
    
      const parts = fileName.split('.');
      return parts.length > 1 ? parts.pop()?.toLowerCase() || '' : '';
  }
  getFileType(value): string {
    let valueStrip = value?.slice(1, value.length -1).split('.');
    let ext = valueStrip[valueStrip.length - 1];  
    return ext?.toLowerCase();
  }
  imageUrl = null;
  
  AllFileViewer = (res)=>{
      this.imageUrl = res;
  }
  closePreview(){
      this.imageUrl = null;
  }
  isActiveUser(id: number): boolean {
    if(!id) return false;
    return this.allActiveUsers.find(e => e?.id == id);
  }
  agentMessageChannel:any;
  private joiningSubscription: Subscription;
  private leavingSubscription: Subscription;
  private listenSubscription: Subscription;
  private hereSubscription: Subscription;
  senderId;

  checkSeen(val){
    let values;
    // Convert the string to an array if it represents an array
    try {
      values = JSON.parse(val);
    } catch (e) {
      // If parsing fails, treat val as a single value
      values = [val];
    }
    if (Array.isArray(values)) {    
      const seenStatusvalue = values?.every(value => this.chatOpenAgent?.includes(String(value)));
      return seenStatusvalue;
    }
    return this.chatOpenAgent.includes(Number(val));
  }

  compareAndModifyArrays(modified) {
    
    modified?.forEach(newObj => {
      // Find the existing object in the initial array by matching a unique property
      const existingObj = this.OperatorData.find(item => item.id === newObj.id);

      if (existingObj) {
        // Update the properties of the existing object if needed
        Object.keys(newObj).forEach(key => {
          if (existingObj[key] !== newObj[key]) {
            existingObj[key] = newObj[key];
          }
        });
      } else {
        // If the object does not exist in the initial array, add it
        this.OperatorData.push(newObj);
      }
    });
  }
  ngAfterViewInit(){
    
    this.agentMessageChannel = (window as any).Echo?.join('angularagentMessage');
    this.joiningSubscription = this.agentMessageChannel?.joining((user) => {
      
      this.allActiveUsers = Object.values(this.agentMessageChannel.subscription.members.members);
      if (!this.chatOpenAgent.includes(this.AuthId) && !isNaN(Number(this.AuthId))){
        this.chatOpenAgent.push(Number(this.AuthId));
      }      
    })
    this.leavingSubscription = this.agentMessageChannel?.leaving((user) => {
      this.allActiveUsers = Object.values(this.agentMessageChannel.subscription.members.members);
      this.chatOpenAgent = this.chatOpenAgent.filter(item => item !== user.id);
    })

    this.listenSubscription = this.agentMessageChannel?.listen('AgentMessageEvent', (socket) => {
      if((socket.unique_id == this.unique_id && socket.unique_id && this.unique_id) || (socket.unique_id && socket.senderId == this.AuthId)){
        let data = {
          unique_id : socket.unique_id,
          type : this.type
        }
        
        this.liceChatService.broadcastoperatorReplyViewed(data).subscribe({
          next: (res) => {
            this.compareAndModifyArrays(res.Conversation);
            this.cdr.markForCheck();
          }
        })
      }
      if(socket.messageStatus == "seen"){
        this.OperatorData = this.OperatorData.map((operator) => {
          if (operator.unique_id === socket.openedUser && operator.message_status !== 'seen') {
            return { ...operator, message_status: 'seen' };
          }
          return operator;
        });
        this.data.allconver = this.data.allconver.map(e => {
          if (e.unique_id === socket.openedUser && e.message_status !== 'seen') {
            return {...e, message_status: 'seen' };
          }
          return e;
        });
      }
      if(socket.senderId == this.AuthId && socket.openedUser ==  this.id){
      }
      if(socket.unique_id && (socket.unique_id == this.unique_id || socket.receiverId == this.AuthId || socket.senderId == this.AuthId) && socket.newgroup == "newGroup" || socket.newgroup == 'newoperator'){
        this.data.allconver.unshift(socket.groupconversation);
      }
      
      if(socket.unique_id && (socket.unique_id == this.unique_id || socket.receiverId == this.AuthId || socket.senderId == this.AuthId) && socket.groupconversation){
          this.data.allconver = this.data.allconver.reduce((acc, e) => {
            if (socket.groupconversation?.unique_id === e.unique_id) {
              return acc;
            } else {
              acc.push(e);
            }
            return acc;
          }, []);
          
          // Now prepend the new item (if applicable)
          if (socket.groupconversation) {
            this.data.allconver.unshift(socket.groupconversation);
          }
        }
      if (socket.openedUser == this.AuthId) {
        if (!isNaN(Number(socket.senderId)) && !this.chatOpenAgent.includes(socket.senderId)){
          // this.chatOpenAgent.push(Number(socket.senderId));          
        }
        if (this.chatOpenAgent.includes(parseInt(this.id))) {
          let operatorConversation = document.querySelector("#operator-conversation");          
          document.querySelectorAll("#operator-conversation .chat-read-icon").forEach((ele) => {
            // To add the Message view induction in chat
            // ele.classList.remove("chat-read-icon")
            // ele.classList.add("chat-read-mark")
            // ele.querySelector('i').className = "ri-check-double-fill"

            // To add the Message view induction in sidebar
            // let SideBarProfile = document.querySelector(
            //     `.checkforactive[data-id='${parseInt(operatorConversation?.getAttribute("operator-id"))}']`
            //     ).querySelector(".chat-read-icon")
            // if (SideBarProfile) {
            //     SideBarProfile.classList.add('chat-read-mark')
            //     SideBarProfile.querySelector('i').className = "ri-check-double-fill"
            //     SideBarProfile.classList.remove('chat-read-icon')
            // }
          })
        }
      }else{
          const valueToRemove = socket.senderId;
          this.chatOpenAgent = this.chatOpenAgent.filter(item => item !== valueToRemove);
      }

      
      if (document.querySelector(`.checkforactive[data-group-uniq='${socket.openedUser}']`)) {
        // Group Array Add
        const existingEntryIndex = this.chatOpenAgent.includes(socket.openedUser);
        if (existingEntryIndex) {
          if (!this.chatOpenAgent.includes(socket.senderId)) {
              if(!isNaN(Number(socket.senderId))){
                // this.chatOpenAgent.push(Number(socket.senderId));
              }

              // Remove sender ID from other entries
              this.chatOpenAgent.forEach((entry, index) => {
                  // const key = Object.keys(entry)[0];
                  // const existingArray = entry[key];

                  // if (index !== existingEntryIndex) {
                  //     const indexOfNumber = entry?.indexOf(socket.senderId);
                  //     if (indexOfNumber !== -1) {
                  //       entry?.splice(indexOfNumber, 1);
                  //     }
                  // }
              });
          }
        }else{
          // To remove the user id from old data
          this.chatOpenAgent.forEach(entry => {
              // const key = Object.keys(entry)[0];
              // const existingArray = entry[key];

              // const indexOfNumber = entry?.indexOf(socket.senderId);
              // if (indexOfNumber !== -1) {
              //     entry?.splice(indexOfNumber, 1);
              // }
          });
          if (!this.chatOpenAgent.includes(socket.senderId) && !isNaN(Number(socket.senderId))){
            // this.chatOpenAgent.push(Number(socket.senderId));
          }
        }
      }
      this.allActiveUsers = Object.values(this.agentMessageChannel.subscription.members.members);

      let groupIncludeDB = socket.groupInclude ? Array.isArray(socket.groupInclude) ? socket.groupInclude : JSON.parse(socket.groupInclude) : []
      if (
        (this.AuthId == socket.receiverId && this.id == socket
            .senderId && socket.message != null) || // Agent Conversation Messages
        (socket.receiverId == this.id && socket.message != null &&
            socket.senderId != this.AuthId && groupIncludeDB.includes(parseInt(this.AuthId))
            ) // Group Conversation Messages
    ) {
    }
    })
    this.hereSubscription = this.agentMessageChannel?.here((users) => { 
      this.allActiveUsers = Object.values(this.agentMessageChannel.subscription.members.members);
      if (!this.chatOpenAgent.includes(this.AuthId) && !isNaN(Number(this.AuthId))){
        this.chatOpenAgent.push(Number(this.AuthId));
      }
    })    
  }

  getClassForUser(e: any): string {
    return this.allActiveUsers?.some(u => u?.id === e) ? 'bg-green' : 'bg-gray';
  }
  override ngOnDestroy(): void {    
    this.data;
    this.settings;
    this.id;
    this.currentDate;
    this.operatorUser;
    this.autoUserInfo;
    this.parsedChatFlowMessages;
    this.chatData;
    this.unique_id;
    this.AuthId;
    
    this.chatOpenAgent = this.chatOpenAgent.filter(item => item !== this.AuthId);
    if(this.agentMessageChannel){
      this.agentMessageChannel.leaving((user) => {
        this.allActiveUsers = Object.values(this.agentMessageChannel.subscription.members.members);
        this.chatOpenAgent = this.chatOpenAgent.filter(item => item !== user.id);
      })
    }
    this.operators$?.unsubscribe();
    if (this.joiningSubscription) {
      this.joiningSubscription.unsubscribe();
    }
    if (this.leavingSubscription) {
      this.leavingSubscription.unsubscribe();
    }
    if (this.listenSubscription) {
      this.listenSubscription.unsubscribe();
    }
    if (this.hereSubscription) {
      this.hereSubscription.unsubscribe();
    }
    // Correct way to leave the channel with Laravel Echo
    if ((window as any).Echo && this.agentMessageChannel) {
      // Leaving the channel through Echo
      (window as any).Echo?.leave('angularagentMessage');
    }
  }
  
  handleFilterOperators(event){
    let val = event.target?.value;
    if(val){
      this.users = this.user.filter(e => e.name.includes(val) || e.email.includes(val))
    }else{
      this.users = this.user;
    }
  }
}
