import { Component, ElementRef, forwardRef, OnInit, QueryList, ViewChildren } from '@angular/core';
import { FormBuilder, FormControl, FormGroup, FormsModule, NG_VALUE_ACCESSOR, ReactiveFormsModule, Validators } from '@angular/forms';
import { Router } from '@angular/router';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { CommonModule } from '@angular/common';
import moment from 'moment-timezone';
import { NgxMatIntlTelInputComponent } from 'ngx-mat-intl-tel-input';
import { NgSelectModule } from '@ng-select/ng-select';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
@Component({
  selector: 'app-create-employee',
  templateUrl: './create-employee.component.html',
  styleUrls: ['./create-employee.component.scss'],
  standalone : true,
  imports : [CommonModule, AdminPageHeaderComponent, TranslatePipes, NgxMatIntlTelInputComponent, NgSelectModule, FormsModule, ReactiveFormsModule ],
  providers: [
    {
      provide: NG_VALUE_ACCESSOR,
      useExisting: forwardRef(() => CreateEmployeeComponent),
      multi: true,
    },
  ],
})
export class CreateEmployeeComponent extends Unsub implements OnInit {
  pswd = Math.random().toString(36).slice(2) + Math.random().toString(36).toUpperCase().slice(2);
  rolesList: any;
  selectedDashboard: string = 'Employee'; // Set the default value here
  departmentList: any;
  timezone: string = 'Asia/Calcutta';
  public sendingResponse: { [key: string]: boolean } = {};
  countries: any;
  timezones: any;
  form: FormGroup;
  constructor(
    private adminService: AdminService,
    private toaster: ToastrService,
    public fb: FormBuilder,
    private router: Router,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);

    this.form = this.fb.group({
      image: null,
    });
    
    this.timezones = moment.tz.names();
  }
  ngOnInit(): void {
    this.loaderService.showLoader();
    this.adminService
      .createEmployeeGetAssets()
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (result) => {
          this.countries = result.countries;
          this.rolesList = result.roles;
          this.departmentList = result.departments;
          this.loaderService.hideLoader();
        },
        error: () => this.loaderService.hideLoader()
      });
    this.skillsNames.forEach((c) => {
      this.skillslist.push(c);
    });
    this.languagesNames.forEach((c) => {
      this.languageslist.push(c);
    });
  }
  public timeZoneChanged(timeZone: string): void {
    this.timezone = timeZone;
  }

  changeimage(event: any) {
    const file = (event.target as HTMLInputElement)?.files?.[0];

    this.form.patchValue({
      image: file,
    });
  }
  createEmployee(ngForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;

      const formData: any = new FormData();
      formData.append('image', this.form.controls['image'].value);
      formData.append('firstname', ngForm.value.firstname);
      formData.append('lastname', ngForm.value.lastname);
      formData.append('empid', ngForm.value.empid);
      formData.append('phone', ngForm.value.phone);
      formData.append('password', ngForm.value.password);
      formData.append('role', ngForm.value.role);
      formData.append('department', ngForm.value.department);
      formData.append('email', ngForm.value.email);
      formData.append('country', ngForm.value.country);
      formData.append('timezone', ngForm.value.timezone);
      formData.append('status', ngForm.value.status);
      formData.append('dashboard', ngForm.value.dashboard);
      if (ngForm.value?.languages?.length) {
        formData.append('languages', ngForm.value?.languages?.length ? ngForm.value.languages.join(',') : ngForm.value.languages);
      }
      if (ngForm.value?.skills?.length) {
        formData.append('skills', ngForm.value?.skills?.length ? ngForm.value.skills.join(',') : ngForm.value.skills);
      }
      console.timeLog(formData);
      this.adminService
        .createEmployee(formData)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.toaster.success(res.success);
              this.form.reset({});
              this.router.navigate(['/admin/manage-roles/employees-list']);
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }

  selectedskills: any;
  skillslist: any[] = [];
  skillsNames = [];
  selectedlanguages: any;
  languageslist: any[] = [];
  languagesNames = [];

  addTagFn(name: any) {
    return name;
  }

  @ViewChildren('filterInput') filterInput!: QueryList<ElementRef>;
  dropdownSearch() {
    this.filterInput.changes.subscribe(res => {
      if (this.filterInput?.first) {
        this.filterInput.first.nativeElement.focus()
      }
    })
  }
}
