import { Routes } from '@angular/router';

export const notifications: Routes = [
      {
        path: "all-notifications", loadComponent:()=>import('./all-notifications/all-notifications.component').then(e=>e.AllNotificationsComponent), data: {
          permission: true
        }
      },
      {
        path: "custom-notifications", loadComponent:()=>import('./custom-notifications/custom-notifications.component').then(e=>e.CustomNotificationsComponent), data: {
          permission: 'Custom Notifications Access'
        }
      },
      {
        path: "compose-employees", loadComponent:()=>import('./compose-employees/compose-employees.component').then(e=>e.ComposeEmployeesComponent), data: {
          permission: 'Custom Notifications Employee'
        }
      },
      {
        path: "compose-customers", loadComponent:()=>import('./compose-customers/compose-customers.component').then(e=>e.ComposeCustomersComponent), data: {
          permission: 'Custom Notifications Customer'
        }
      },
      {
        path: "notification/:id", loadComponent:()=>import('./custom-notification-view/custom-notification-view.component').then(e=>e.CustomNotificationViewComponent), data: {
          permission: 'Custom Notifications View'
        }
      },
];