import { SelectionModel } from '@angular/cdk/collections';
import { Component, OnInit, ViewChild } from '@angular/core';
import { FormsModule, NgForm } from '@angular/forms';
import { MatPaginator } from '@angular/material/paginator';
import { MatSort } from '@angular/material/sort';
import { MatTableDataSource } from '@angular/material/table';
import { RouterLink } from '@angular/router';
import { NgbTooltipModule, NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { NgSelectModule } from '@ng-select/ng-select';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { Subject, takeUntil, debounceTime, distinctUntilChanged, switchMap, Observable, tap } from 'rxjs';
import Swal from 'sweetalert2';
import { MaterialeModules } from '../../../../material.module';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { TranslationService } from '../../../../shared/services/translation.service';
import { CommonModule, DatePipe } from '@angular/common';

@Component({
  selector: 'app-custom-invoices',
  standalone: true,
  imports: [AdminPageHeaderComponent, TranslatePipes, MaterialeModules, NgbTooltipModule, FormsModule, NgSelectModule, RouterLink, CommonModule],
  providers:[DatePipe],
  templateUrl: './custom-invoices.component.html',
  styleUrl: './custom-invoices.component.scss'
})
export class CustomInvoicesComponent  extends Unsub implements OnInit {
  public sendingResponse: { [key: string]: boolean } = {};
  public projects: any;
  public completeprojects: any[] = [];
  public projectid: any;
  public projectname: any;
  private searchTerms = new Subject<string>();
  categories;
  url = "";
  configData;
  displayedColumns: string[] = ['sno', 'invoiceid', 'customer', 'amount','invoiceDate','status','paymode','paydate', 'actions'];
  dataSource!: MatTableDataSource<any>;
  selection = new SelectionModel<any>(true, []);
  refreshToken$: any;
  permission: any;
  isloader = true;
  timezone = "UTC";
  public selCat: any = [];
  catCheck;
  @ViewChild(MatPaginator) paginator!: MatPaginator;
  @ViewChild(MatSort) sort!: MatSort;

  constructor(
    private adminService: AdminService,
    private toastr: ToastrService,
    private modalService: NgbModal,
    private translate: TranslatePipe,
    private translationService: TranslationService,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.translationService.TranslationStatus.subscribe(() => {
      setTimeout(() => {
        this.paginator._intl.itemsPerPageLabel = this.translate.transform('items per page:');
        this.paginator._intl.nextPageLabel = this.translate.transform('next');
        this.paginator._intl.previousPageLabel = this.translate.transform('previous');
        this.paginator._intl.firstPageLabel = this.translate.transform('first page');
        this.paginator._intl.lastPageLabel = this.translate.transform('last page');
        const of = this.translate.transform('of');
        this.paginator._intl.getRangeLabel = (page: number, pageSize: number, length: number) => {
          if (length == 0 || pageSize == 0) return `0 ${of} ${length}`;
          length = Math.max(length, 0);
          const startIndex = page * pageSize;
          const endIndex = startIndex < length ? Math.min(startIndex + pageSize, length) : startIndex + pageSize;

          return `${startIndex + 1} - ${endIndex} ${of} ${length}`;
        };
      }, 100);
    });
    this.translationService.setTranslationaStatus(true);
    this.url = location.origin + document.querySelector('base')?.getAttribute('href');
  }

  ngOnInit(): void {
    this.allProjects();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        this.allProjects();

      }
    });

    this.searchTerms.pipe(
      debounceTime(300),
      distinctUntilChanged(),
      switchMap((): any => this.loadData())
    ).subscribe();
  }
  allProjects() {
    this.isloader = true;
    this.loaderService.showLoader();
    this.adminService
      .customInvoices(1, 10, this.filterValue)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next:
          (res) => {
            this.permission = res.permissions;
            this.catCheck = res.check_category;
            this.projects = res.queryList;
            this.categories = res.categories;
            this.timezone = res.timezonedata
            this.configData = res.configData;

            // Assign the data to the data source for the table to render
            this.isloader = false;
            this.dataSource = new MatTableDataSource(this.projects.data);
            if (this.dataSource) {
              this.paginator.pageSize = this.projects.per_page;
              setTimeout(() => {
                this.paginator.pageIndex = this.projects.current_page - 1;
                this.paginator.length = this.projects.total;
              });
              this.dataSource.paginator = this.paginator;

              // this.sort.disableClear = true; // Used to disbale the original soting of data if enabled (Only ASC, DES).
              this.dataSource.sort = this.sort;
              this.dataSource.sortingDataAccessor = (data, sortHeaderId) => {
                switch (sortHeaderId) {
                  case 'user':
                  case 'ticketdetails':
                  case 'status':
                    return this.nestedProperty(data, sortHeaderId);
                  default:
                    return this.nestedCaseInsensitive(data, sortHeaderId);
                }
              }
            }
            this.loaderService.hideLoader();
          },
        error: () => {
          this.isloader = true;
          this.loaderService.hideLoader()
        },
      }
      );
  }

  filterValue = "";
  applyFilter(event: Event) {
    this.filterValue = (event.target as HTMLInputElement).value;
    this.searchTerms.next(this.filterValue);
  }
  getStatusElement(status: string): string {
    switch (status) {
      case 'paid':
      case 'completed':
        return `<span class="badge bg-success-transparent">${this.translate.transform('Completed')}</span>`;
      case 'pending':
        return `<span class="badge bg-warning-transparent">${this.translate.transform('Payment Pending')}</span>`;
      case 'refundpending':
        return `<span class="badge bg-info-transparent">${this.translate.transform('Refund Pending')}</span>`;
      case 'refunded':
        return `<span class="badge bg-success-transparent">${this.translate.transform('Refunded')}</span>`;
      case 'refundRejected':
        return `<span class="badge bg-danger-transparent">${this.translate.transform('Refund Rejected')}</span>`;
      case 'cancelled':
        return `<span class="badge bg-danger-transparent">${this.translate.transform('Invoice Cancelled')}</span>`;
      default:
        return '';
    }
  }

  // Example to get the status for a specific row
  getStatus(row: any): string {
    return this.getStatusElement(row?.status);
  }
  /** Whether the number of selected elements matches the total number of rows. */
  isAllSelected() {
    const numSelected = this.selection.selected.length;
    let numRows;
    if (this.dataSource) {
      numRows = this.dataSource.data.length;
    }
    return numSelected === numRows;
  }
  /** Selects all rows if they are not all selected; otherwise clear selection. */
  toggleAllRows() {
    if (this.isAllSelected()) {
      this.selection.clear();
      return;
    }

    this.selection.select(...this.dataSource.data);
  }

  /** The label for the checkbox on the passed row */
  checkboxLabel(row?: any): string {
    if (!row) {
      return `${this.isAllSelected() ? 'deselect' : 'select'} all`;
    }
    return `${this.selection.isSelected(row) ? 'deselect' : 'select'} row ${row?.id + 1
      }`;
  }


  addProject(ngForm: NgForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const data = {

        id: ngForm.value.id,
        name: ngForm.value.name,
      };
      this.adminService
        .createProjects(data)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next:
            (res) => {
              this.sendingResponse[buttonId] = false;
              if (res.errors) {
                this.toastr.error(this.translate.transform(res.errors));
              }
              if (res.success) {
                this.modalService.dismissAll();
                this.toastr.success(this.translate.transform(res.success));
              }
            },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        }
        );
    }
  }
  
  deleteRequestFun(id: any, buttonId) {
    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure ?'),
      text: this.translate.transform('Your will not be able to recover!'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Yes, delete it!'),
      cancelButtonText: this.translate.transform('Close'),
      reverseButtons: true,
    }).then((result: any) => {
      if (result.isConfirmed) {
        this.sendingResponse[buttonId] = true;
        this.adminService
          .invoiceDelete(id)
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next:
              (res) => {
                this.sendingResponse[buttonId] = false;
                if (res.success) {
                  this.toastr.success(this.translate.transform(res.success));
                }
              },
            error: () => {
              this.sendingResponse[buttonId] = false;
            },
          }
          );
      }
    });
  }
  cancleRequestFun(id: any, buttonId) {
    const data = {
      id: id,
    };
    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure ?'),
      text: this.translate.transform('Your will not be able to recover!'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Yes, Cancle it!'),
      cancelButtonText: this.translate.transform('Close'),
      reverseButtons: true,
    }).then((result: any) => {
      if (result.isConfirmed) {
        this.sendingResponse[buttonId] = true;
        this.adminService
          .cancelInvoice(id)
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next:
              (res) => {
                this.sendingResponse[buttonId] = false;
                if (res.success) {
                  this.toastr.success(this.translate.transform(res.success));
                }
              },
            error: () => {
              this.sendingResponse[buttonId] = false;
            },
          }
          );
      }
    });
  }

  public assignProjects: any = [];

  

  loadData(): Observable<any> {
    this.isloader = true;
    return this.adminService.customInvoices(this.paginator.pageIndex + 1, this.paginator.pageSize, this.filterValue).pipe(
      tap((data: any) => {
        this.isloader = false;
        this.dataSource.data = data.queryList.data;
        setTimeout(() => {
          this.paginator.pageIndex = data.queryList.current_page - 1;
          this.paginator.length = data.queryList.total;
          this.paginator.pageSize = data.queryList.per_page;
        });
      }));
  }

  onPaginateTable() {
    this.selection.clear();
    this.loadData().subscribe();
  }
  override ngOnDestroy() {
    this.modalService?.dismissAll();
  }
  // this is needed to allow sorting on nested properties
  nestedProperty = (data: any, sortHeaderId: string): string | number => {
    return sortHeaderId
      ?.split('.')
      .reduce((accumulator, key) => accumulator && accumulator[key], data) as
      | string
      | number;
  };
  // this is needed to have caseInsensitive sorting
  caseInsensitive = (data: any, sortHeaderId: string): string | number => {
    const value = data[sortHeaderId];
    return typeof value === 'string' ? value.toUpperCase() :
      value;
  };
  nestedCaseInsensitive = (data: any, sortHeaderId: string): string | number => {
    const value = sortHeaderId
      ?.split('.')
      .reduce((accumulator, key) => accumulator && accumulator[key], data) as
      | string
      | number;
    return typeof value === 'string' ? value.toUpperCase() : value;
  };
}
