import { CommonModule, DatePipe, JsonPipe } from '@angular/common';
import { Component, ElementRef, ViewChild } from '@angular/core';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil, fromEvent } from 'rxjs';
import Swal from 'sweetalert2';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { Unsub } from '../../../../shared/class/unsub.class';
import { RouterLink } from '@angular/router';
import { FormsModule } from '@angular/forms';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { FlatpickrDirective, provideFlatpickrDefaults } from 'angularx-flatpickr';

@Component({
  selector: 'app-employee-activity',
  standalone: true,
  imports: [CommonModule, AdminPageHeaderComponent, TranslatePipes, FormsModule, RouterLink, FlatpickrDirective, JsonPipe],
  providers: [DatePipe, provideFlatpickrDefaults()],
  templateUrl: './employee-activity.component.html',
  styleUrl: './employee-activity.component.scss'
})
export class EmployeeActivityComponent extends Unsub {
  @ViewChild('commentsClose') commentsClose!: ElementRef;
  allNotificationList: any;
  setting;
  today: string | null;
  yesterday: any = new Date();
  public sendingResponse: { [key: string]: boolean } = {};
  authtimezone: any;
  authname: any;
  totalnotifications: any;
  notifysearch: any = null;
  notifydate: any = null;
  constructor(
    private adminService: AdminService,
    private datePipe: DatePipe,
    private toastr: ToastrService,
    private translate: TranslatePipe,
    loaderService: LoaderService,
    private sanitizer: DomSanitizer
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.employeeActivity();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        this.employeeActivity();
      },
    });
    this.today = datePipe.transform(Date.now(), 'yyyy-MM-dd');
    this.yesterday = datePipe.transform(
      this.yesterday.setDate(this.yesterday.getDate() - 1),
      'yyyy-MM-dd'
    );
  }
  statusnotify: any[] = [];

  ngOnInit(): void {
    const notifyCheckBox = document.querySelectorAll('.notifystatus');
    const notifySearchInp: any = document.querySelector('.notifysearch');
    const notifyDateInp: any = document.querySelector('.notifydate');
    const notifysearch = fromEvent(notifySearchInp, 'keyup');
    notifysearch.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (event: any) => {
        // const data = {
        this.notifysearch = event.target.value;
        this.employeeActivity();
      },
    });
    const notifystatus = fromEvent(notifyCheckBox, 'click');
    notifystatus.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: () => {
        this.statusnotify = [];
        document.querySelectorAll("input[name='notifystatus[]']:checked").forEach((event) => {
          this.statusnotify.push(event['value']);
        });
        this.employeeActivity();
      },
    });
    const notifydate = fromEvent(notifyDateInp, 'change');
    notifydate.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (event:any) => {
        this.notifydate = event.target.value;
        this.employeeActivity();
      },
    });
  }
  isLoading = true;
  employeeActivity() {
    this.isLoading = true;
    this.loaderService.showLoader();
    this.adminService
    .employeeActivity(1, JSON.stringify(this.statusnotify), this.notifysearch, this.notifydate)
    .pipe(takeUntil(this.unSubscribe$))
    .subscribe({
      next: (res) => {
          this.isLoading = false;
          this.authtimezone = res.authtimezone;
          this.authname = res.authname;
          this.setting = res.setting?.original;
          this.totalnotifications = res.queryList?.total;
          this.pageCount = res.queryList?.current_page + 1;
          this.allNotificationList = res.queryList?.data;
          this.loaderService.hideLoader();
        },
        error: () => this.loaderService.hideLoader()
      });
  }

  private lastDate: string | null = null;
  shouldShowDateBadge(currentDate: string): boolean {
    if (currentDate !== this.lastDate) {
      this.lastDate = currentDate;
      return true;
    }
    return false;
  }
  private intersectionObserver!: IntersectionObserver;
  public isLoadingComments: boolean = false;
  ngAfterViewInit() {
    this.intersectionObserver = new IntersectionObserver((entries) => {
      if (entries[0].isIntersecting && !this.isLoadingComments && this.allNotificationList?.length < this.totalnotifications) {
        this.loadComments();
        this.isLoadingComments = true;
      }
    }, { threshold: 0 });
    const myElement = this.commentsClose.nativeElement;
    this.intersectionObserver.observe(myElement);
  }
  pageCount;

  loadComments() {

    this.adminService.employeeActivity(this.pageCount, JSON.stringify(this.statusnotify), this.notifysearch, this.notifydate)
      .subscribe((res: any) => {
        this.isLoadingComments = false;
        this.pageCount = res.queryList.current_page + 1;
        this.allNotificationList = [...this.allNotificationList, ...res.queryList.data];
      });
  }

  override ngOnDestroy() {
    if (this.intersectionObserver) {
      this.intersectionObserver.disconnect();
    }
  }
  sanitizeHtml(html: string): SafeHtml {
    return this.sanitizer.bypassSecurityTrustHtml(html);
  }
}

