import { Component, OnInit, Input, ViewChild, ChangeDetectionStrategy, Output, EventEmitter } from '@angular/core';
import { FormBuilder, FormGroup, FormsModule, NgForm } from '@angular/forms';
import { ActivatedRoute } from '@angular/router';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { Observable, concatMap, interval, takeUntil } from 'rxjs';
import { AngularEditorConfig, AngularEditorModule } from '@kolkov/angular-editor';
import { Unsub } from '../../../../shared/class/unsub.class';
import { adminToolbar } from '../../../../shared/data/editortoolbar';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { NgSelectModule } from '@ng-select/ng-select';
import { NgbAccordionModule, NgbDropdownMenu, NgbDropdownModule, NgbTooltipModule } from '@ng-bootstrap/ng-bootstrap';
import { ImageUploadComponent } from '../../../../shared/common/includes/image-upload/image-upload.component';
import { MaxLengthValidatorDirective } from '../../../../shared/directives/max-length-validator.directive';
import { MinLengthValidatorDirective } from '../../../../shared/directives/min-length-validator.directive';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { debounce } from 'lodash';

@Component({
  selector: 'app-showticketinclude',
  templateUrl: './showticketinclude.component.html',
  styleUrls: ['./showticketinclude.component.scss'],
  standalone: true,
  imports: [TranslatePipes, AngularEditorModule, NgSelectModule, NgbTooltipModule, NgbAccordionModule, ImageUploadComponent, MaxLengthValidatorDirective, MinLengthValidatorDirective, FormsModule, NgbDropdownModule]
})
export class ShowticketincludeComponent extends Unsub implements OnInit {
  @ViewChild('replyBox') replyBox: any;
  @ViewChild('replyBtn', { static: false }) replyBtn: any;
  @Output() employIsWorking = new EventEmitter<any>();
  cannedResponse;
  form: FormGroup;
  reopenTkt = false;
  holdremove = false;
  ratingonoff = false;
  public featureimage: any[] = [];
  public sendingResponse: { [key: string]: boolean } = {};
  toolbar: AngularEditorConfig = adminToolbar;
  ticketName: any[] = [];
  currentStatus = 'InProgress';
  ticketDataParent: any = {}
  @Input() setting: any; // decorate the property with @Input()
  @Input() user: any; // decorate the property with @Input()
  replayStatus: any;
  // @Input() ticketDataParent: any; // decorate the property with @Input()
  @Input()
  get data(): any {
    return this.ticketDataParent;
  }
  set data(value: any) {
    if (value) {
      this.ticketDataParent = value;
      if (this.ticketDataParent?.ticket?.status == 'Re-Open' || this.ticketDataParent?.ticket?.status == 'Inprogress' || this.ticketDataParent?.ticket?.status == 'New') {
        this.currentStatus = 'Inprogress'
      } else {
        if (this.ticketDataParent?.ticket?.status == 'On-Hold') {
          this.ratingStatus('On-Hold')
        }
        this.currentStatus = this.ticketDataParent?.ticket?.status;
      }
      if (this.ticketDataParent?.ticketdraft?.description || localStorage.getItem(`adminReply${this.ticketDataParent?.ticket?.ticket_id}`)) {
        this.reply = this.ticketDataParent?.ticketdraft?.description || localStorage.getItem(`adminReply${this.ticketDataParent?.ticket.ticket_id}`);
      }
    }
  }
  constructor(
    private adminService: AdminService,
    private toastr: ToastrService,
    public fb: FormBuilder,
    private route: ActivatedRoute,
    private translate: TranslatePipe, loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.form = this.fb.group({
      image: null,
    });
    this.toolbar.placeholder = this.translate.transform('Enter Your Text...');
  }

  lastPollTime = 0;
  ngOnInit(): void {
    interval(5000).pipe(
      concatMap(() => {
        const currentTime = Date.now();
        if (this.lastPollTime + 1000 <= currentTime) {
          this.lastPollTime += 1000;
          if (this.ticketDataParent?.ticket) {
            return this.adminService.getemployeesreplying(this.ticketDataParent?.ticket?.id);
          } else {
            return new Observable<void>((observer) => {
              observer.complete();
            });
          }
        } else {
          return new Observable<void>((observer) => {
            observer.complete();
          });
        }
      })
    ).pipe(takeUntil(this.unSubscribe$)).subscribe((res) => {
      this.replayStatus = res;
      if (this.replayStatus?.employees?.length) {
        this.toolbar['editable'] = false;
      } else {
        this.toolbar['editable'] = true;
      }
    });

  }
  ticketReply(ngform: NgForm, buttonId) {
    if (ngform.valid && !this.replayStatus?.employees?.length) {

      this.sendingResponse[buttonId] = true;
      const formData: any = new FormData();
      formData.append('comment', this.reply);
      formData.append('status', ngform.value.status);
      formData.append('note', ngform.value.note);
      formData.append('cannedmessage', ngform.value.cannedmessage);
      formData.append('id', this.ticketDataParent?.ticket.enc_ticket_id);
      formData.append('ticket_id', this.ticketDataParent?.ticket?.id);
      if (ngform.value.reopen_on_off) {
        formData.append('reopen_on_off', ngform.value.reopen_on_off);
      }
      if (ngform.value.rating_on_off) {
        formData.append('rating_on_off', ngform.value.rating_on_off);
      }
      for (let i = 0; i < this.ticketName?.length; i++) {
        formData.append('comments[]', this.ticketName[i]);
      }
      formData.append('mediaRemoved', this.mediaRemoved)
      this.adminService
        .replyTicket(this.ticketDataParent?.ticket.enc_ticket_id, formData).pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.ratingonoff = false;
            this.reopenTkt = false;
            this.sendingResponse[buttonId] = false;
            if (res?.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.reply = "";
              localStorage.removeItem(`adminReply${this.ticketDataParent?.ticket.ticket_id}`);
              ngform.reset();
              this.ticketName = [];
              this.form.reset({});
              this.replyBox?.collapseAll();
            }
            if (res?.error) {
              this.toastr.error(this.translate.transform(res.error));
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }
  setGenerated(val){
    this.generated = val;
  }
  saveToDraft(ngform: NgForm, buttonId) {
    if (ngform.valid) {
      this.sendingResponse[buttonId] = true;

      const formData: any = new FormData();
      if (this.ticketDataParent?.ticketdraft?.id) {
        formData.append('draft_id', this.ticketDataParent?.ticketdraft?.id);
      }
      formData.append('ticket_id', this.ticketDataParent?.ticket?.id);
      formData.append('comment', this.reply);
      formData.append('id', this.ticketDataParent?.ticket.enc_ticket_id);
      for (let i = 0; i < this.ticketName?.length; i++) {
        formData.append('comments[]', this.ticketName[i]);
      }
      formData.append('mediaRemoved', this.mediaRemoved)
      this.adminService
        .ticketdraft(formData).pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {

            this.currentStatus = 'Inprogress';
            this.ticketName = [];
            if (res?.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.reply = "";
              localStorage.removeItem(`adminReply${this.ticketDataParent?.ticket.ticket_id}`);
              this.replyBox?.collapseAll();
            }
            if (res?.error) {
              this.toastr.error(this.translate.transform(res.error));
            }
            this.sendingResponse[buttonId] = false;
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }
  cannedResponseFn(value) {
    this.reply = value.messages;
  }
  ratingStatus(event) {
    switch (event) {
      case 'Inprogress':
        this.ratingonoff = false;
        this.reopenTkt = false;
        this.holdremove = false;
        break;
      case 'Solved':
        this.ratingonoff = true;
        this.reopenTkt = true;
        this.holdremove = false;
        break;
      case 'On-Hold':
        this.ratingonoff = false;
        this.reopenTkt = false;
        this.holdremove = true;
        break;
    }
  }

  employeesreplyingstore(isTyping){
    const post = {};
    post['userID'] = this.user.id;
    post['ticketId'] = this.ticketDataParent?.ticket?.id;
    post['isTyping'] = isTyping,
      post['content'] = this.reply;
    this.adminService.employeesreplyingstore(post).pipe(takeUntil(this.unSubscribe$)).subscribe({});
  }
  inactivityTimeout: any;
  resetInactivityTimer() {
    
    clearTimeout(this.inactivityTimeout);
    this.inactivityTimeout = setTimeout(() => {
      this.employeesreplyingstore(false);
    }, 60000);
  }
  onBlurReply() {
    this.employeesreplyingstore(false);
    clearTimeout(this.inactivityTimeout);
  }
  onfocusReply() {
    this.employeesreplyingstore(true);
    this.resetInactivityTimer();
  }
  reply: any = "";
  handleDataFromChild(value: string) {
    this.reply = value;
  }
  handleTypingDebounced = debounce(() => {
    this.employeesreplyingstore(true);
    this.resetInactivityTimer();
  }, 500);
  onChange(value) {
    this.employIsWorking.emit(true)
    localStorage.setItem(`adminReply${this.ticketDataParent?.ticket.ticket_id}`, this.reply)

    this.handleTypingDebounced();
  }

  mediaRemoved: number[] = [];
  onImageUploaded(value) {
    this.ticketName = value.ticketName;
    if (value.mediaremoveIds) {
      value.mediaremoveIds.forEach(e => this.mediaRemoved.push(e.id))
    }
  }

  draftdelete(id, buttonId) {
    this.sendingResponse[buttonId] = true;
    this.adminService.draftdelete(id).subscribe({
      next: (res) => {
        this.toastr.success(this.translate.transform(res.success));
        this.sendingResponse[buttonId] = false;
      },
      error: err => this.sendingResponse[buttonId] = false
    })
  }
  removeDraftImg(id) {
    this.adminService.ticketdraftimage(id).subscribe({
      next: (res) => {
        this.toastr.success(this.translate.transform(res.success));
      }
    })
  }
  makeApiCall(): void {
    const post = {
      userID: this.user.id,
      ticketId: this.ticketDataParent?.ticket?.id,
    };

    this.adminService.employeesreplyingremove(post)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (response) => {
        },
        error: (err) => {
          console.error('API call failed:', err);
        },
      });
  } 
  
  showGeneratedText = false;
  generatedDescription = '';
  generatedTextContent = '';
  isGenerating = false;
  generated = { title: 'Generate', value: 'generatetext' };

  private timeoutId: any;


  generateFn() {
    const prompt = this.reply;

    this.isGenerating = true;

    if (this.generated.value === 'generatetext') {
      const generatePrompt = `Please generate a detailed and coherent text based on the following input: "${prompt}". The text should cover all key points and be suitable for use in a professional context.`;
      this.textGenTextOnlyPrompt(generatePrompt);
    } else {
      const improvePrompt = `Please enhance the following text to make it more professional and clear for email communication: "${prompt}". Ensure that it maintains the original meaning while improving the overall tone and readability.`;
      this.textGenTextOnlyPrompt(improvePrompt);
    }
  }

  private textGenTextOnlyPrompt(prompt: string) {
    this.adminService.generateTextFn({ prompt }).subscribe({
      next: res =>{
        
        this.isGenerating = false;
        this.showGeneratedText = true;
        this.generatedTextContent = res.generated_text;
        this.typeText(res.generated_text, 7);
      }
    })
  }

  regenerateFn() {
    this.stopTyping();
    const userPrompt = this.generatedDescription;
    const regeneratePrompt = `I am not satisfied with the previous text. Please provide a new version of the following text with a different approach, ensuring it remains professional and suitable for email communication: "${userPrompt}". Focus on changing the structure and wording while retaining the original meaning.`;
    this.generatedDescription = '';
    this.textGenTextOnlyPrompt(regeneratePrompt);
  }

  useFn() {
    this.reply = this.generatedTextContent;
    this.stopTyping();
    this.showGeneratedText = false;
  }

  stopTyping() {
    if (this.timeoutId) {
      clearTimeout(this.timeoutId);
    }
  }

  private typeText(text: string, speed: number) {
    let index = 0;
    this.generatedDescription = '';
    
    const type = () => {
      if (index < text.length) {
        this.generatedDescription += text.charAt(index++);
        this.timeoutId = setTimeout(type, speed);
      }
    };

    type();
  }

  closeGeneratedText() {
    this.stopTyping();
    this.showGeneratedText = false;
  }
}
