import { Component, OnInit, ViewChild } from '@angular/core';
import { TranslatePipe } from '@ngx-translate/core';
import { Unsub } from '../../../../shared/class/unsub.class';
import { AdminService } from '../../../../shared/services/admin/admin.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { takeUntil } from 'rxjs';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AdminPageHeaderComponent } from '../../../../shared/common/pageheader/admin-page-header/admin-page-header.component';
import { AdminTicketTableComponent } from '../../../../shared/common/includes/admin-ticket-table/admin-ticket-table.component';

@Component({
  selector: 'app-recent-tickets',
  templateUrl: './recent-tickets.component.html',
  styleUrls: ['./recent-tickets.component.scss'],
  standalone : true,
  imports: [AdminPageHeaderComponent, TranslatePipes, AdminTicketTableComponent]
})
export class RecentTicketsComponent extends Unsub implements OnInit {
  public activeTickets: any;
  setting;
  displayedColumns: string[] = [
    'id',
    'select',
    'ticketdetails',
    'user',
    'status',
    'assignto',
    'actions',
  ];
  permission: any;
  isloader = true;
  timezone: any;

  constructor(
    private adminService: AdminService,
    private translate: TranslatePipe,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
  }

  ngOnInit(): void {
    this.recenttickets();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        this.recenttickets();

      },
    });
  }
  recenttickets() {
    this.isloader = true;
    this.loaderService.showLoader();
    this.adminService
      .recenttickets(1, 10, '')
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.permission = res.permissions;

          this.activeTickets = res.queryList;
          this.timezone = res?.timezonedata;

          // Assign the data to the data source for the table to render
          this.isloader = false;
          this.setting = res.setting?.original;
          if (!this.permission?.includes('Ticket Delete')) {
            this.displayedColumns = [
              'id',
              'ticketdetails',
              'user',
              'status',
              'assignto',
              'actions',
            ];
          }
          this.loaderService.hideLoader();
        },
       error: () => {this.isloader = true;  this.loaderService.hideLoader()}
      });
  }

  loadData(params) {
    this.isloader = true;
    this.adminService.recenttickets(params.page, params.size, params.filter).subscribe(
      {
        next: (data: any) => {
          this.isloader = false;
          this.activeTickets = data.queryList;
        },
        error : err => this.isloader = false
      });
  }
}
