import { AdminService } from '../../../../shared/services/admin/admin.service';
import { Component, OnInit } from '@angular/core';
import { ToastrService } from 'ngx-toastr';
import { ActivatedRoute, Router } from '@angular/router';
import Swal from 'sweetalert2';
import { NgbModal, NgbPopoverModule, NgbTooltipModule } from '@ng-bootstrap/ng-bootstrap';
import { takeUntil } from 'rxjs';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { TranslatePipe } from '@ngx-translate/core';
import { Unsub } from '../../../../shared/class/unsub.class';
import { LoaderService } from '../../../../shared/services/loader.service';
import { CommonModule } from '@angular/common';
import { DateAgoPipe } from '../../../../shared/pipes/date-ago/date-ago.pipe';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
@Component({
  selector: 'app-trashed-tickets-view',
  templateUrl: './trashed-tickets-view.component.html',
  styleUrls: ['./trashed-tickets-view.component.scss'],
  standalone : true,
  imports : [CommonModule, DateAgoPipe, TranslatePipes, NgbTooltipModule, NgbPopoverModule ]
})
export class TrashedTicketsViewComponent extends Unsub implements OnInit {
  id;
  public sendingResponse: { [key: string]: boolean } = {};
  trashedTicketData;
  now = new Date();
  timezone: any;
  userroles: any;
  constructor(
    private adminService: AdminService,
    private toastr: ToastrService,
    private activatedRoute: ActivatedRoute,
    public router: Router,
    private translate: TranslatePipe,
    private modalService: NgbModal,
    loaderService: LoaderService,  private sanitizer: DomSanitizer
  ) {
    super(loaderService);
    this.activatedRoute.paramMap.subscribe({
      next: (params: any) => {
        this.id = params.get('id');
        this.loaderService.showLoader();
        this.adminService.myTrashedTicketView(this.id).subscribe({
          next: (res) => {
            
          if (res?.noticket) {
            this.router.navigate(['/admin/trashed-tickets']);
            this.toastr.error(this.translate.transform(res.noticket));
          }else{
            this.trashedTicketData = res;
            this.userroles = res.userroles;
            this.timezone = res.timezonedata;
          }
            this.loaderService.hideLoader();
          },
          error: () => this.loaderService.hideLoader()
        });
      },
    });
  }

  ngOnInit(): void { }

  deleteTicketPermanent(buttonId) {
    const data = {

    };
    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure ?'),
      text: this.translate.transform('Your will not be able to recover!'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Yes, delete it!'),
      cancelButtonText: this.translate.transform('Close'),
      reverseButtons: true,
    }).then((result: any) => {
      if (result.isConfirmed) {
        this.sendingResponse[buttonId] = true;
        this.adminService
          .myTrashedTicketsDelete(
            data,
            this.trashedTicketData.tickettrashedview.id
          )
          .subscribe({
            next: (res) => {
              this.sendingResponse[buttonId] = false;
              if (res.success) {
                this.router.navigate(['/admin/trashed-tickets']);
                this.modalService.dismissAll();
                this.toastr.success(this.translate.transform(res.success));
              }
            },
            error: () => {
               this.sendingResponse[buttonId] = false;
            },
          });
      }
    });
  }
  restoreDelete(buttonId) {
    const data = {

    };

    Swal.fire({
      icon: 'warning',
      title: this.translate.transform('Are you sure ?'),
      text: this.translate.transform('Your Ticket will be Restored'),
      showCancelButton: true,
      confirmButtonColor: '#6259ca',
      cancelButtonColor: '#f11541',
      confirmButtonText: this.translate.transform('Yes, Restore it!'),
      cancelButtonText: this.translate.transform('Close'),
      reverseButtons: true,
    }).then((result: any) => {
      if (result.isConfirmed) {
        this.sendingResponse[buttonId] = true;
        this.adminService
          .myTrashedTicketsRestore(
            data,
            this.trashedTicketData.tickettrashedview.id
          )
          .subscribe({
            next: (res) => {
              this.sendingResponse[buttonId] = false;
              if (res.success) {
                this.toastr.success(this.translate.transform(res.success));
                this.router.navigate(['/admin/trashed-tickets']);
              }
            },
            error: () => {
               this.sendingResponse[buttonId] = false;
            },
          });
      }
    });
  }
  // ticketlicenseverify
  purchasedata;
  verifyTicket(ticketData, content) {
    const modalRef = this.modalService.open(content, { backdrop: 'static', keyboard: false });
    modalRef.result.then(
      () => { },
      () => { }
    );
    const data = {
      "envatopurchase_id": ticketData,
    };
    this.adminService.ticketlicenseverify(data).pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (res) => {
        this.purchasedata = res.output;
      },
    });
  }
  sanitizeHtml(html: string): SafeHtml {
    return this.sanitizer.bypassSecurityTrustHtml(html);
  }
}
