import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { CaptchaService } from '../../../shared/services/admin/captcha.service';
import { GuestService } from '../../../shared/services/guest.service';
import { RecaptchaModule, RecaptchaV3Module } from 'ng-recaptcha';
import { TranslatePipes } from '../../../shared/pipes/translate/translate.pipe';
import { FormsModule } from '@angular/forms';
import { SharedModule } from '../../../shared/shared.module';
import { ToastrService } from 'ngx-toastr';
import { TranslatePipe } from '@ngx-translate/core';

@Component({
  selector: 'app-ipblock',
  templateUrl: './ipblock.component.html',
  styleUrls: ['./ipblock.component.scss'],
  standalone : true,
  imports: [TranslatePipes, FormsModule, RecaptchaModule, RecaptchaV3Module, SharedModule]
})
export class IpblockComponent implements OnInit {
  captchaStatus: boolean = false;
  setting;
  returnUrl: any;
  captcha: any;
  constructor(private guestService: GuestService, private activatedRoute: ActivatedRoute, private router: Router,
    private captchService: CaptchaService, private translate: TranslatePipe, private toastr: ToastrService) {
    this.returnUrl =
      this.activatedRoute.snapshot.queryParams['returnUrl'] ||
      '/';
  }

  ngOnInit(): void {
    this.guestService.getCapchaType().subscribe({
      next : res =>{
        this.setting = res;
      }
    })
  }

  ipblockupdate(ngForm) {
    if (ngForm.valid) {
      const data = ngForm.value;
      
      if (this.setting?.CAPTCHATYPE=='manual' && this.setting?.RECAPTCH_ENABLE_CONTACT == 'yes') {
        if (!this.captchaStatus) {
          this.toastr.error(this.translate.transform('Captcha Invalid'));
          return;
        }
      }
      if (this.captchaStatus) {
        data['captcha'] = 'valid';
      }
      this.guestService.ipblockupdate(data).subscribe({
        next: res => {
          if (res?.success) {
            this.router.navigate([this.returnUrl]);
          }
        },
        error: () => {
          this.captchService.setCaptchaStatus(false);
        }
      });
    }
  }
  captchaMessage = '';
  manualCaptchEvent(value: any) {
    if(!value?.optional){
      if (value.generated == value.input) {
        this.captchaStatus = true;
        this.captchaMessage = '';
      } else if(value.input == '') {
        this.captchaMessage = 'Enter valid captcha';
        this.captchaStatus = false;
      }else{
        this.captchaStatus = false;
      }
    }
  }
  public resolved(captchaResponse: string | any): void {
    this.captcha = captchaResponse;
  }
}
