import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router, RouterLink } from '@angular/router';
import { interval, takeUntil } from 'rxjs';
import { Unsub } from '../../../shared/class/unsub.class';
import { GuestService } from '../../../shared/services/guest.service';
import { LoaderService } from '../../../shared/services/loader.service';
import { TranslatePipes } from '../../../shared/pipes/translate/translate.pipe';

@Component({
  selector: 'app-multiplerequests',
  templateUrl: './multiplerequests.component.html',
  styleUrls: ['./multiplerequests.component.scss'],
  standalone : true,
  imports: [TranslatePipes, RouterLink]
})
export class MultiplerequestsComponent extends Unsub implements OnInit {

  setting;
  pendingtime;
  redireurl: any;
  constructor(private guestService: GuestService, private activatedRoute: ActivatedRoute, private router: Router, 
    loaderService: LoaderService) {
     /**
     * This code calls the constructor of the parent class in a subclass. 
     * The super() function is used to initialize the parent class and allows access to its properties and methods. 
     * By calling  super(), the subclass can inherit and use the functionality of the parent class.
     **/
    super(loaderService);
    this.loaderService.showLoader();
    this.guestService.error429().pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: res => {
        this.setting = res.setting?.original;
        this.pendingtime = this.setting.IPSECONDS;
        this.loaderService.hideLoader();
      },
      error : ()=> this.loaderService.hideLoader()
    });
  }

  ngOnInit(): void {
    interval(1000)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: () => {
          if(this.pendingtime > 0){
            this.pendingtime = this.pendingtime - 1;
          }
          if(this.pendingtime == 0){
            this.router.navigate([this.activatedRoute.snapshot.queryParams['returnUrl']]);
            this.redireurl = this.activatedRoute.snapshot.queryParams['returnUrl'];
          }
      },
      });
  }

}
