
import { Component, OnInit } from '@angular/core';
import { takeUntil } from 'rxjs';
import { Router } from '@angular/router';
import { Unsub } from '../../../shared/class/unsub.class';
import { GuestService } from '../../../shared/services/guest.service';
import { LoaderService } from '../../../shared/services/loader.service';

import { TranslatePipes } from '../../../shared/pipes/translate/translate.pipe';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';

@Component({
  selector: 'app-page-not-found',
  templateUrl: './page-not-found.component.html',
  styleUrls: ['./page-not-found.component.scss'],
  standalone : true,
  imports: [TranslatePipes]
})
export class PageNotFoundComponent extends Unsub implements OnInit {
  safeSubtitle: SafeHtml | null = null;
  safetitle: SafeHtml | null = null;
  setting;
  constructor(private guestService: GuestService, loaderService: LoaderService, private route: Router, private sanitizer: DomSanitizer, private translate: TranslatePipes) {
     /**
     * This code calls the constructor of the parent class in a subclass. 
     * The super() function is used to initialize the parent class and allows access to its properties and methods. 
     * By calling  super(), the subclass can inherit and use the functionality of the parent class.
     **/
super(loaderService);
    this.guestService.error404().pipe(takeUntil(this.unSubscribe$)).subscribe({
      next :res => { this.setting = res.setting?.original;
        this.safetitle = this.sanitizer.bypassSecurityTrustHtml(this.translate.transform(this.setting?.['404title']));
        this.safeSubtitle = this.sanitizer.bypassSecurityTrustHtml(this.translate.transform(this.setting?.['404subtitle']));
      }
    });
  }
  
  ngOnInit(): void {}
  
  returnBack(){
    if(this.route.url.match('admin')){
      this.route.navigate(['/admin']);
    }
    else if(this.route.url.match('customer')){
      this.route.navigate(['/customer']);
    }else{
      this.route.navigate(['/']);
    }
  }
}
