import { Component, OnInit } from '@angular/core';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../../shared/class/unsub.class';
import { GuestService } from '../../../shared/services/guest.service';
import { LoaderService } from '../../../shared/services/loader.service';

import { TranslatePipes } from '../../../shared/pipes/translate/translate.pipe';

@Component({
  selector: 'app-undermaintenance',
  templateUrl: './undermaintenance.component.html',
  styleUrls: ['./undermaintenance.component.scss'],
  standalone : true,
  imports: [TranslatePipes]
})
export class UndermaintenanceComponent extends Unsub implements OnInit {

  setting;
  constructor(private guestService: GuestService, loaderService: LoaderService) {
     /**
     * This code calls the constructor of the parent class in a subclass. 
     * The super() function is used to initialize the parent class and allows access to its properties and methods. 
     * By calling  super(), the subclass can inherit and use the functionality of the parent class.
     **/
super(loaderService);
    this.guestService.error503().pipe(takeUntil(this.unSubscribe$)).subscribe({
      next : res => this.setting = res.setting?.original
    });
   }

  ngOnInit(): void {
  }

}
