import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { TranslatePipe } from '@ngx-translate/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../../../shared/class/unsub.class';
import { CustomersService } from '../../../../shared/services/customers/customers.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { CommonModule } from '@angular/common';


@Component({
  selector: 'app-customer-verify',
  templateUrl: './customer-verify.component.html',
  styleUrls: ['./customer-verify.component.scss'],
  standalone : true,
  imports: [CommonModule]
})
export class CustomerVerifyComponent extends Unsub implements OnInit {

  constructor(private router: Router, private activatedRoute: ActivatedRoute, private customerService: CustomersService, private toastr: ToastrService, private translate: TranslatePipe,
    loaderService: LoaderService) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    activatedRoute.params.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (params) => {
        this.loaderService.showLoader();
        this.customerService
          .verifytoken(params['id'])
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (res) => {

              if (res?.['success']) {
                this.toastr.success(this.translate.transform(res['success']));
                if (res?.['redirect']) {
                  this.router.navigate(['/']);
                }
                this.router.navigate(['/customer/login']);
              }
              if (res?.['warning']) {
                this.toastr.warning(this.translate.transform(res['warning']));
                this.router.navigate(['/customer/login']);
              }
              this.loaderService.hideLoader();
            },
            error: () => this.loaderService.hideLoader()
          });
      },
    });
  }

  ngOnInit(): void {
  }

}
