import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { Router, RouterLink } from '@angular/router';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { CookieService } from 'ngx-cookie-service';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { TranslatePipe } from '@ngx-translate/core';
import { Unsub } from '../../../../shared/class/unsub.class';
import { CaptchaService } from '../../../../shared/services/admin/captcha.service';
import { GeneralSettingsService } from '../../../../shared/services/admin/general-settings.service';
import { CustomersService } from '../../../../shared/services/customers/customers.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { RecaptchaModule, RecaptchaV3Module } from 'ng-recaptcha';
import { NgbAlertModule, NgbTooltipModule } from '@ng-bootstrap/ng-bootstrap';
import { CommonModule } from '@angular/common';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { AnnouncementHolidayBannerComponent } from '../../../../shared/common/includes/announcement-holiday-banner/announcement-holiday-banner.component';
import { FormsModule } from '@angular/forms';
import { SharedModule } from '../../../../shared/shared.module';


@Component({
  selector: 'app-login',
  templateUrl: './login.component.html',
  styleUrls: ['./login.component.scss'],
  standalone : true,
  imports: [CommonModule, TranslatePipes, RecaptchaModule, RecaptchaV3Module, NgbTooltipModule, RouterLink, NgbAlertModule, AnnouncementHolidayBannerComponent, FormsModule, SharedModule]
})
export class LoginComponent extends Unsub implements OnInit {
  @ViewChild('password') password!: ElementRef;
  data;
  status = false;
  public sendingResponse: { [key: string]: boolean } = {};
  captchaStatus: boolean =false;
  captcha: any;
  hideAlertsUntil: { [key: string]: number } = {};
  constructor(
    private customerService: CustomersService,
    private toastr: ToastrService,
    private router: Router,
    public generalSettingsService: GeneralSettingsService,
    private cookieService: CookieService,
    private captchService: CaptchaService,
    private translate: TranslatePipe,
    loaderService: LoaderService, private sanitizer: DomSanitizer
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.loaderService.showLoader();
    this.customerService
      .getcustomerLogin()
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.data = res;
          this.status = true;
          if (res) {
            res.announcement?.forEach(alert => {
              const hideAlertsUntil = this.cookieService.get('anct' + alert.id);
              if (hideAlertsUntil) {
                this.hideAlertsUntil['anct' + alert.id] = parseInt(hideAlertsUntil, 10);
              }
            })
            res.announcements?.forEach(alert => {
              const hideAlertsUntil = this.cookieService.get('anct' + alert.id);
              if (hideAlertsUntil) {
                this.hideAlertsUntil['anct' + alert.id] = parseInt(hideAlertsUntil, 10);
              }
            })
            res.holidays?.forEach(alert => {
              const hideAlertsUntil = this.cookieService.get('holiday' + alert.id);
              if (hideAlertsUntil) {
                this.hideAlertsUntil['holiday' + alert.id] = parseInt(hideAlertsUntil, 10);
              }
            })
          }
          this.loaderService.hideLoader();
        },
        error: () => this.loaderService.hideLoader()
      });
  }
  ngOnInit(): void {

  }

  customerLogin(ngForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const data = ngForm.value;
      
      if (this.data?.setting?.original?.CAPTCHATYPE=='manual' && this.data?.setting?.original?.RECAPTCH_ENABLE_LOGIN == 'yes') {
        if (!this.captchaStatus) {
          this.toastr.error(this.translate.transform('Captcha Invalid'));
          this.sendingResponse[buttonId] = false;
          return;
        }
      }
      if (this.captchaStatus) {
        data['captcha'] = 'valid';
      }
      if (this.data?.setting?.original?.login_disable == 'on') {
        this.toastr.error(this.translate.transform(this.data?.setting?.original?.login_disable_statement));
        this.sendingResponse[buttonId] = false;
      } else {
        this.customerService
          .customerLogin(data)
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next:
              (res) => {
                this.sendingResponse[buttonId] = false;
                if (res?.success) {
                  ngForm.reset();
                  this.toastr.success(this.translate.transform(res.success));
                  if(res?.redirectionstatus){
                    if(res.redirectionstatus == 'googletwofact'){
                      this.router.navigate([`/customer/customergoogle2fa/${res?.email}`]);
                    }else if(res.redirectionstatus == 'twofactoremail'){
                      this.router.navigate([`/customer/customertwofactor/${res?.email}`]);
                    }
                  }else{
                    this.router.navigate(['/customer/dashboard']);
                  }
                }
                if (res?.error?.errors) {
                  ngForm.value.password = null;
                  this.password.nativeElement.value = null;
                  for (const el in res.error.errors) {
                    this.toastr.error(this.translate.transform(res.error.errors[el]));
                  }
                } else if (res?.error) {
                  this.toastr.error(this.translate.transform(res.error));
                }
                ngForm.value.password = null;
                this.password.nativeElement.value = null;
                this.captchService.setCaptchaStatus(false);

              },
            error: () => {
              this.captchService.setCaptchaStatus(false);
              ngForm.value.password = null;
              this.password.nativeElement.value = null;
              this.sendingResponse[buttonId] = false;
            },
          }
          );
      }
    }
  }
  public resolved(captchaResponse: string | any): void {
    this.captcha = captchaResponse;
  }

  socialLogin(callback) {
    this.customerService.scoialLogin(callback).subscribe(res => {
      if (res?.['redirect']) {
        location.href = res['redirect'];
      }
    });
  }

  captchaMessage = '';
  manualCaptchEvent(value: any) {
    if(!value?.optional){
      if (value.generated == value.input) {
        this.captchaStatus = true;
        this.captchaMessage = '';
      } else if(value.input == '') {
        this.captchaMessage = 'Enter valid captcha';
        this.captchaStatus = false;
      }else{
        this.captchaStatus = false;
      }
    }
  }
}
