import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router, RouterLink } from '@angular/router';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { CookieService } from 'ngx-cookie-service';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { TranslatePipe } from '@ngx-translate/core';
import { Unsub } from '../../../../shared/class/unsub.class';
import { CustomersService } from '../../../../shared/services/customers/customers.service';
import { LoaderService } from '../../../../shared/services/loader.service';
import { NgbAlertModule } from '@ng-bootstrap/ng-bootstrap';
import { CommonModule } from '@angular/common';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';
import { FormsModule } from '@angular/forms';
import { AnnouncementHolidayBannerComponent } from '../../../../shared/common/includes/announcement-holiday-banner/announcement-holiday-banner.component';


@Component({
  selector: 'app-reset-password',
  templateUrl: './reset-password.component.html',
  styleUrls: ['./reset-password.component.scss'],
  standalone : true,
  imports: [CommonModule, TranslatePipes, RouterLink, NgbAlertModule, FormsModule, AnnouncementHolidayBannerComponent]
})
export class ResetPasswordComponent extends Unsub implements OnInit {
  data;
  hideAlertsUntil: { [key: string]: number } = {};
  public sendingResponse: { [key: string]: boolean } = {};
  constructor(
    private customerService: CustomersService,
    private router: Router,
    private toastr: ToastrService,
    private activedRoute: ActivatedRoute,
    private translate: TranslatePipe,
    private cookieService: CookieService,
    loaderService: LoaderService,  private sanitizer: DomSanitizer
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    activedRoute.params.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (params) => {
        this.loaderService.showLoader();
        this.customerService
          .getResetData(params['id'])
          .pipe(takeUntil(this.unSubscribe$))
          .subscribe({
            next: (res) => {
              if (!res?.user) {
                this.router.navigate(['/customer']);
              }
              this.data = res;
              if (res) {
              res.announcement?.forEach(alert => {
                const hideAlertsUntil = this.cookieService.get('anct' + alert.id);
                if (hideAlertsUntil) {
                  this.hideAlertsUntil['anct' + alert.id] = parseInt(hideAlertsUntil, 10);
                }
              })
              res.announcements?.forEach(alert => {
                const hideAlertsUntil = this.cookieService.get('anct' + alert.id);
                if (hideAlertsUntil) {
                  this.hideAlertsUntil['anct' + alert.id] = parseInt(hideAlertsUntil, 10);
                }
              })
              res.holidays?.forEach(alert => {
                const hideAlertsUntil = this.cookieService.get('holiday' + alert.id);
                if (hideAlertsUntil) {
                  this.hideAlertsUntil['holiday' + alert.id] = parseInt(hideAlertsUntil, 10);
                }
              })
              }
              if (res.user == null) {
                this.toastr.error(this.translate.transform('Password already reseted'));
                this.router.navigate(['/customer']);
              }
              this.loaderService.hideLoader();
            },
            error: () => this.loaderService.hideLoader()
          });
      },
    });
  }

  ngOnInit(): void { }

  resetPswd(ngForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      const data = {
        "token": this.data?.user?.token,
        "email": this.data?.user?.email,
        "password": ngForm.value.password,
        "password_confirmation": ngForm.value.password_confirmation,
      };
      this.customerService
        .resetPsw(data)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res?.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.router.navigate(['/customer']);
            }
            if (res?.error) {
              this.toastr.error(this.translate.transform(res.error));
            }
          },
          error: () => {
            this.sendingResponse[buttonId] = false;
          },
        });
    }
  }


}
