import { Component, OnInit, ViewChild, ElementRef } from '@angular/core';
import { ToastrService } from 'ngx-toastr';
import { takeUntil } from 'rxjs';
import { FormBuilder, FormGroup, FormsModule, NgForm } from '@angular/forms';
import { Router, RouterLink } from '@angular/router';
import { TranslatePipe } from '@ngx-translate/core';
import { AngularEditorConfig, AngularEditorModule } from '@kolkov/angular-editor';
import { Unsub } from '../../../shared/class/unsub.class';
import { customerToolbar } from '../../../shared/data/editortoolbar';
import { AdminService } from '../../../shared/services/admin/admin.service';
import { CustomersService } from '../../../shared/services/customers/customers.service';
import { LoaderService } from '../../../shared/services/loader.service';
import { NgbAlertModule, NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { NgSelectModule } from '@ng-select/ng-select';
import { CommonModule } from '@angular/common';
import { CookieService } from 'ngx-cookie-service';
import { DomSanitizer } from '@angular/platform-browser';
import { TranslatePipes } from '../../../shared/pipes/translate/translate.pipe';
import { AnnouncementHolidayBannerComponent } from '../../../shared/common/includes/announcement-holiday-banner/announcement-holiday-banner.component';
import { ImageUploadComponent } from '../../../shared/common/includes/image-upload/image-upload.component';
import { MinLengthValidatorDirective } from '../../../shared/directives/min-length-validator.directive';
import { MaxLengthValidatorDirective } from '../../../shared/directives/max-length-validator.directive';
import { BusinessHourCardListComponent } from '../../../shared/common/business-hour-card-list/business-hour-card-list.component';

@Component({
  selector: 'app-create-ticket',
  templateUrl: './create-ticket.component.html',
  styleUrls: ['./create-ticket.component.scss'],
  standalone : true,
  imports: [CommonModule, TranslatePipes, NgbAlertModule, AngularEditorModule, NgSelectModule, AnnouncementHolidayBannerComponent, ImageUploadComponent, MinLengthValidatorDirective, MaxLengthValidatorDirective, FormsModule, BusinessHourCardListComponent]
})
export class CreateTicketComponent extends Unsub implements OnInit {
  @ViewChild('verifysupportexpired') verifysupportexpired!: ElementRef;
  @ViewChild('supportexpired') supportexpired!: ElementRef;
  public sendingResponse: { [key: string]: boolean } = {};
  public categories: any[] = [];
  public selectedCity: any;
  envatoName;
  responseCreateTicket: any;
  form: FormGroup;
  featureimage: any[] = [];
  ticketName: any[] = [];
  newTicketLimit = '';
  setting;
  businesshours;
  toolbar: AngularEditorConfig = customerToolbar;
  constructor(
    private customersService: CustomersService,
    private toastr: ToastrService,
    private adminService: AdminService,
    public fb: FormBuilder,
    private modalService: NgbModal,
    public router: Router,private cookieService: CookieService,private sanitizer: DomSanitizer,
    private translate: TranslatePipe,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);

    this.settingInprogress();

    this.form = this.fb.group({
      image: null,
    });
    this.toolbar.placeholder = this.translate.transform('Enter Your Text...');
  }

  settingInprogress = () => {
    this.loaderService.showLoader();
    this.customersService.TicketControllercreate().subscribe({
      next: (res) => {
        if (res?.error) {
          this.toastr.error(this.translate.transform(res.error));
          this.newTicketLimit = res.error;
        }

        this.responseCreateTicket = res;
        this.businesshours = res.businesshours;
        res.holidays.forEach(alert => {
          const hideAlertsUntil = this.cookieService.get(alert.id);
          if (hideAlertsUntil) {
            this.hideAlertsUntils[alert.id] = parseInt(hideAlertsUntil, 10);
          }
        })
        this.categories = res.categories;
        this.setting = res.setting?.original;

        if (res?.customfields) {
          res?.customfields?.forEach((element) => {
            if (
              (element.fieldtypes == 'radio' ||
                element.fieldtypes == 'checkbox') && element.status == 1
            ) {
              this.customfield['custom_' + element.id] = {
                status: element.fieldrequired,
              };
              if (element.fieldrequired == 1) {
                this.checkStatus = true;
              }
            }
          });
        }
        this.loaderService.hideLoader();
      },
      error: () => this.loaderService.hideLoader()
    });
  };

  ngOnInit(): void {
  }
  
  openModel(content){
    this.modalService.open(content, { backdrop: 'static', keyboard: false, size: 'md' });
  }
  newTicket(ngForm: NgForm, buttonId) {
    const cf = this.customfield;
    const newCf = {};
    for (const i in cf) {
      const e = cf[i].val;
      newCf[i] = e;
    }
    if (
      this.haspurchasecode.length
        ? this.licencekeyStatus && ngForm.valid && !this.checkStatus && !this.categoryStatus
        : ngForm.valid && !this.checkStatus && !this.categoryStatus
    ) {

      this.sendingResponse[buttonId] = true;
      const formData: any = new FormData();

      // Append ngForm values if they exist and key is not 'envato_id'
      for (const key of Object.keys(ngForm.value)) {
        const val = ngForm.value[key];
        if (key !== 'envato_id' && val !== null && val !== undefined && val !== '') {
          formData.append(key, val);
        }
      }
      
      // Append newCf values if they exist
      for (const key of Object.keys(newCf)) {
        const val = newCf[key];
        if (val !== null && val !== undefined && val !== '') {
          formData.append(key, val);
        }
      }
      
      // Append ticketName array values if they exist
      if (Array.isArray(this.ticketName)) {
        for (let i = 0; i < this.ticketName.length; i++) {
          const item = this.ticketName[i];
          if (item !== null && item !== undefined && item !== '') {
            formData.append('ticket[]', item);
          }
        }
      }
      
      // Append optional values if they exist
      if (this.licencekey) {
        formData.append('envato_id', this.licencekey);
      }
      if (this.licencesupport) {
        formData.append('envato_support', this.licencesupport);
      }
      
      // Append agree_terms only if it is true
      if (ngForm.value.agree_terms) {
        formData.append('agree_terms', 'agreed');
      }
      
      this.customersService
        .TicketControllerStore(formData)
        .pipe(takeUntil(this.unSubscribe$))
        .subscribe({
          next: (res) => {
            this.sendingResponse[buttonId] = false;
            if (res && res.success) {
              ngForm.reset();
              this.toastr.success(this.translate.transform(res.success));
              this.router.navigate(['/customer/ticket-view/'+ res.ticket_id]);
              this.form.reset({});
            }
            if (res && res.error?.message) {
              this.toastr.error(this.translate.transform(res.error.message));
            }
            else if (res && res.error) {
              this.toastr.error(this.translate.transform(res.error));
            }
          },
          error: () => {
             this.sendingResponse[buttonId] = false;
          },
        });
    }
  }

  onImageUploaded(value) {
    this.ticketName = value.ticketName;
  }

  categoryStatus = false;
  category = [];
  subcategory = null;
  projects = null;
  userDetails;
  haspurchasecode = [];
  hassubcategoriess = [];
  hasproject = [];
  envatoId;
  categorychange(id) {
    this.subcategory = null;
    this.projects = null;
    this.envatoName = null;
    this.licencekey = '';
    this.licencesupport = null;
    this.categoryStatus = true;
    const data = {
      "cat_id": id,
    };
    this.adminService.getCatagoryData(data).subscribe({
      next: (res) => {
        this.categoryStatus = false;
        if (res.ENVATO_ON == 'on') {
          this.haspurchasecode = res.envatosuccess;
        }
        this.hasproject = res.projects;
        this.hassubcategoriess = res.subcategories;
      },
    });
  }

  licencekey;
  licencekeyStatus = false;
  licencesupport;
  envatoVerify(event) {
    if (event.value?.trim().length == 36) {
      this.envatoId = event.value.trim();
      const data = {
        data: event.value,
      };
      this.adminService.envatoverify(data).subscribe({
        next: (res) => {
          if (res?.valid != 'true') {

            if (this.responseCreateTicket.ENVATO_EXPIRED_BLOCK == 'on') {
              this.toastr.error(this.translate.transform(res.message));
              this.supportexpired?.nativeElement.classList.remove('d-none');
              this.verifysupportexpired?.nativeElement.classList.add('d-none');
              this.licencekeyStatus = false;
            }
            if (this.responseCreateTicket.ENVATO_EXPIRED_BLOCK == 'off') {
              if (res?.invalid) {
                this.toastr.error(this.translate.transform(res.message));
                this.licencekeyStatus = false;
              }
              else {
                this.supportexpired?.nativeElement.classList.add('d-none');
                this.verifysupportexpired?.nativeElement.classList.remove('d-none');
                this.toastr.warning(this.translate.transform(res.message));
                this.envatoName = res.name;
                this.licencekey = res.key;
                this.licencekeyStatus = true;
                this.licencesupport = res.valid;
              }

            }

          }
          if (res?.valid == 'true') {
            this.supportexpired.nativeElement.classList.add('d-none');
            this.verifysupportexpired.nativeElement.classList.add('d-none');
            this.toastr.success(this.translate.transform(res.message));
            this.envatoName = res.name;
            this.licencekey = res.key;
            this.licencekeyStatus = true;
            this.licencesupport = res.valid;
          }
        },
      });
    }
  }

  customfield = {};
  checkStatus = false;
  checkCount: any[] = [];
  customfieldSection(res, name, type): void {
    this.checkStatus = true;
    this.checkCount = [];
    if (type == 'radio') {
      this.customfield[name].val = res;
    }
    if (type == 'checkbox') {
      if (this.customfield[name].val?.includes(res)) {
        this.customfield[name].val = this.customfield[name].val.filter((x) => {
          return x != res;
        });
      } else {
        if (this.customfield[name].val) {
          this.customfield[name].val.push(res);
        } else {
          this.customfield[name].val = [res];
        }
      }
    }
    for (const i in this.customfield) {
      if (this.customfield[i].status == 1) {
        if (this.customfield[i]?.val?.length) {
          continue;
        } else {
          this.checkCount.push(this.customfield[i]);
        }
      }
    }
    if (this.checkCount.length) {
      this.checkStatus = true;
    } else {
      this.checkStatus = false;
    }
  }


  

  hideAlertsUntils: { [key: string]: number } = {};
  
}
