import { Component, OnInit } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { takeUntil } from 'rxjs';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { Unsub } from '../../../shared/class/unsub.class';
import { CustomersService } from '../../../shared/services/customers/customers.service';
import { LoaderService } from '../../../shared/services/loader.service';
import { CommonModule } from '@angular/common';
import { SharedModule } from '../../../shared/shared.module';
import { TimezonePipe } from '../../../shared/pipes/timzone.pipe';
@Component({
  selector: 'app-notifications',
  templateUrl: './notifications.component.html',
  styleUrls: ['./notifications.component.scss'],
  standalone : true,
  imports : [CommonModule, SharedModule, TimezonePipe]
})
export class NotificationsComponent extends Unsub implements OnInit {
  data;
  id;
  user;
  timezone: any;
  constructor(
    private customerService: CustomersService,
    private activatedRoute: ActivatedRoute,
    loaderService: LoaderService,
    private sanitizer: DomSanitizer
  ) {
     /**
     * This code calls the constructor of the parent class in a subclass. 
     * The super() function is used to initialize the parent class and allows access to its properties and methods. 
     * By calling  super(), the subclass can inherit and use the functionality of the parent class.
     **/
super(loaderService);
    this.activatedRoute.paramMap.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: (params) => {
        this.id = params.get('id');
        this.notificationView();
      },
    });
  }

  ngOnInit(): void {}

  notificationView() {
    this.loaderService.showLoader();
    this.customerService.notificationView(this.id).pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: (res) => {
        this.data = res;
        this.timezone = this.user?.timezone;
        this.loaderService.hideLoader();
      },
      error : ()=> this.loaderService.hideLoader()
    });
  }
  sanitizeHtml(html: string): SafeHtml {
    if(html) return this.sanitizer.bypassSecurityTrustHtml(html);
    return '';
  }
}
