import { ChangeDetectionStrategy, ChangeDetectorRef, Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { takeUntil } from 'rxjs';
import { ToastrService } from 'ngx-toastr';
import { ActivatedRoute, RouterLink } from '@angular/router';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { TranslatePipe } from '@ngx-translate/core';
import { Unsub } from '../../../shared/class/unsub.class';
import { AdminService } from '../../../shared/services/admin/admin.service';
import { GuestService } from '../../../shared/services/guest.service';
import { LoaderService } from '../../../shared/services/loader.service';
import { CommonModule } from '@angular/common';
import { NgbModal, NgbTooltipModule } from '@ng-bootstrap/ng-bootstrap';
import { TranslatePipes } from '../../../shared/pipes/translate/translate.pipe';
import { FormsModule } from '@angular/forms';
import { NgSelectModule } from '@ng-select/ng-select';
@Component({
  selector: 'app-articalview',
  templateUrl: './articalview.component.html',
  styleUrls: ['./articalview.component.scss'],
  standalone : true,
  imports : [CommonModule, TranslatePipes, RouterLink, NgbTooltipModule, FormsModule, NgSelectModule ],
  changeDetection: ChangeDetectionStrategy.OnPush
})
export class ArticalviewComponent extends Unsub implements OnInit {
  @ViewChild('seachBackdrop') seachBackdrop!: ElementRef;
  public sendingResponse: { [key: string]: boolean } = {};
  articleData;
  setting;
  languages: any;
  customer;
  id;
  faqloading = true;
  dropdownData;
  constructor(
    private guestService: GuestService,
    private adminService: AdminService,
    private toastr: ToastrService,
    private activedRoute: ActivatedRoute,
        private modalService: NgbModal,
    private translate: TranslatePipe,
    loaderService: LoaderService,  private sanitizer: DomSanitizer, private cdr: ChangeDetectorRef
  ) {
     /**
     * This code calls the constructor of the parent class in a subclass. 
     * The super() function is used to initialize the parent class and allows access to its properties and methods. 
     * By calling  super(), the subclass can inherit and use the functionality of the parent class.
     **/
    super(loaderService);
    this.activedRoute.paramMap.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (params) => {
        this.id = params.get('id');
        this.articles();
      },
    });
  }

  articles() {
    this.loaderService.showLoader();
    this.guestService
      .articleView(this.id)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.customer = res?.username;
          this.languages = Object.keys(res.languages).map(key => ({ id: key, name: res.languages[key] }));
          if (res.error) {
            this.articleData = res.data;
            this.setting = res.data.setting?.original;
            this.toastr.error(this.translate.transform(res.error));
          } else {
            this.articleData = res;
            this.setting = res.setting?.original;
          }
          this.loaderService.hideLoader();
          this.faqloading = false;
          this.cdr.detectChanges();
        },
        error: () => { this.loaderService.hideLoader(); this.faqloading = false; }
      });
  }

  search(event) {
    const data = {
        data: event.target.value,
    };
    this.guestService
      .searchArt(data)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.dropdownData = res;
          // Manually trigger change detection if needed
          this.cdr.detectChanges();
          if(this.dropdownData){
            const backdrop = this.seachBackdrop.nativeElement;
            backdrop.style.display = 'block'; // Hide the backdrop 
          }
        },
      });
  }
  closeSearchBakcDrop(){
    const backdrop = this.seachBackdrop.nativeElement;
    backdrop.style.display = 'none'; // Hide the backdrop 
    this.dropdownData = [];
  }
  ngOnInit(): void {
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        if (this.id) {
          this.articles();
        }
      },
    });
  }

  likedislike(arg, id) {
    const data = {
        dataname: id,
      datavalue: arg,
    };
    this.guestService
      .likedislike(data)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
        },
      });
  }
  sanitizeHtml(html: string, sanitizeId): SafeHtml {
    return this.sanitizer.bypassSecurityTrustHtml(html);
  }

  downloadFile(id, image){
    this.guestService.image(id, image).subscribe({
      next: (res: Blob)=>{ 
        const blobUrl = window.URL.createObjectURL(res);
          const link = document.createElement('a');
          link.href = blobUrl;
          link.setAttribute('download', image); // Set a default filename, customize as needed
          document.body.appendChild(link);
          link.click();
          document.body.removeChild(link);
          window.URL.revokeObjectURL(blobUrl);
      }
    })
  }

  
  textToTranslate;
  titleToTranslate;
  translateModel(content) {
    this.textToTranslate = this.articleData?.articles?.message;
    this.titleToTranslate = this.articleData?.articles?.title;
    this.modalService.open(content, { backdrop: 'static', keyboard: false, size: 'lg' });
  }

  translateFn(ngForm, buttonId) {
    if (ngForm.valid) {
      // this.sendingResponse[buttonId] = true;
      let data = {
        text: this.textToTranslate,
        target_lang: ngForm.value.languages,
        title : this.titleToTranslate,
        user: 'customer',
      }
      this.adminService.translate(data).pipe(takeUntil(this.unSubscribe$)).subscribe({
        next:
          (res) => {
            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.articleData.articles.message = res.translated_text;
              this.articleData.articles.title = res.translated_title;
              this.cdr.detectChanges();
              this.modalService.dismissAll();
            }
            if (res.message) {
              this.toastr.error(this.translate.transform('Translation failed: ' + res.message));
            }
            if (res?.error?.errors) {
              for (const el in res.error.errors) {
                this.toastr.error(this.translate.transform(res.error.errors[el]));
              }
            }
            else if (res.errors) {
              // Iterate through each error key (e.g., subcategoryname)
              Object.keys(res.errors).forEach(key => {
                // If there are errors for that key, display them
                res.errors[key].forEach((error: string) => {
                  this.toastr.error(this.translate.transform(error));
                });
              });
            }
          },
        error: () => {
        },
      }
      );
    }
  }
}
