import { ChangeDetectorRef, Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { ActivatedRoute, RouterLink } from '@angular/router';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../../shared/class/unsub.class';
import { AdminService } from '../../../shared/services/admin/admin.service';
import { GuestService } from '../../../shared/services/guest.service';
import { LoaderService } from '../../../shared/services/loader.service';
import { TranslatePipes } from '../../../shared/pipes/translate/translate.pipe';

@Component({
  selector: 'app-caterogy',
  templateUrl: './caterogy.component.html',
  styleUrls: ['./caterogy.component.scss'],
  standalone : true,
  imports: [TranslatePipes, RouterLink]
})
export class CaterogyComponent extends Unsub implements OnInit {
  @ViewChild('seachBackdrop') seachBackdrop!: ElementRef;
  data;
  dropdownData;
  id;
  constructor(
    private guestService: GuestService,
    private adminService: AdminService,
    private activedRoute: ActivatedRoute,
    loaderService: LoaderService,private cdr: ChangeDetectorRef
  ) {
     /**
     * This code calls the constructor of the parent class in a subclass. 
     * The super() function is used to initialize the parent class and allows access to its properties and methods. 
     * By calling  super(), the subclass can inherit and use the functionality of the parent class.
     **/
super(loaderService);
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        this.category();
      },
    });
    this.activedRoute.paramMap.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (params) => {
        this.id = params.get('id');
        this.category();
      },
    });
  }

  category() {
    this.loaderService.showLoader();
    this.guestService
      .categoryView(this.id)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.data = res;
          this.loaderService.hideLoader();
        },
        error : ()=> this.loaderService.hideLoader()
      });
  }

  search(event) {
    const data = {
        data: event.target.value,
    };
    this.guestService
      .searchArt(data)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.dropdownData = res;
          // Manually trigger change detection if needed
          this.cdr.detectChanges();
          if(this.dropdownData){
            const backdrop = this.seachBackdrop.nativeElement;
            backdrop.style.display = 'block'; // Hide the backdrop 
          }
        },
      });
  }
  closeSearchBakcDrop(){
    const backdrop = this.seachBackdrop.nativeElement;
    backdrop.style.display = 'none'; // Hide the backdrop 
    this.dropdownData = undefined;
  }
  ngOnInit(): void {}
}
