import { ChangeDetectorRef, Component, OnInit } from '@angular/core';
import { ActivatedRoute, RouterLink } from '@angular/router';
import { takeUntil } from 'rxjs';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { Unsub } from '../../../shared/class/unsub.class';
import { GuestService } from '../../../shared/services/guest.service';
import { LoaderService } from '../../../shared/services/loader.service';

import { NgbAccordionModule, NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { TranslatePipes } from '../../../shared/pipes/translate/translate.pipe';
import { ToastrService } from 'ngx-toastr';
import { AdminService } from '../../../shared/services/admin/admin.service';
import { TranslatePipe } from '@ngx-translate/core';
import { FormsModule } from '@angular/forms';
import { NgSelectModule } from '@ng-select/ng-select';

@Component({
  selector: 'app-faq-category',
  templateUrl: './faq-category.component.html',
  styleUrls: ['./faq-category.component.scss'],
  standalone: true,
  imports: [TranslatePipes, RouterLink, NgbAccordionModule, FormsModule, NgSelectModule]
})
export class FaqCategoryComponent extends Unsub implements OnInit {
  faqloading = true;
  public sendingResponse: { [key: string]: boolean } = {};
  faq: any;
  languages: any;
  id!: string | null;
  constructor(private guestService: GuestService, private activeRoute: ActivatedRoute,
    private translate: TranslatePipe,
    private modalService: NgbModal, private toastr: ToastrService, private adminService: AdminService,
    loaderService: LoaderService, private sanitizer: DomSanitizer,private cdr: ChangeDetectorRef) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
  }

  ngOnInit(): void {

    this.activeRoute.paramMap.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (params) => {
        this.id = params.get('id');

        this.loaderService.showLoader();
        this.guestService.faqcategorypage(this.id).pipe(takeUntil(this.unSubscribe$)).subscribe({
          next: res => {
            this.faq = res;
            this.languages = Object.keys(res.languages).map(key => ({ id: key, name: res.languages[key] }));
            this.loaderService.hideLoader();
            this.faqloading = false;
          },
          error: () => { this.loaderService.hideLoader(); this.faqloading = false; }
        });
      }
    });
  }
  sanitizeHtml(html: string): SafeHtml {
    return this.sanitizer.bypassSecurityTrustHtml(html);
  }


  textToTranslate;
  selectedFaq;
  translateModel(content, faq) {
    this.selectedFaq = faq;
    this.modalService.open(content, { backdrop: 'static', keyboard: false, size: 'lg' });
  }

  translateFn(ngForm, buttonId) {
    if (ngForm.valid) {
      this.sendingResponse[buttonId] = true;
      let data = {
        text: this.selectedFaq.answer,
        title: this.selectedFaq.question,
        target_lang: ngForm.value.languages,
        user: 'employee',
      }
      this.adminService.translate(data).pipe(takeUntil(this.unSubscribe$)).subscribe({
        next:
          (res) => {
            this.sendingResponse[buttonId] = false;
            if (res.success) {
              this.toastr.success(this.translate.transform(res.success));
              this.modalService.dismissAll();
              
              this.faq.faqcategory.faqdetails = this.faq?.faqcategory?.faqdetails.map((item) => {
                if (item?.id === this.selectedFaq.id) {
                  return { ...item, answer: res.translated_text, question: res.translated_title }; // Update the specific FAQ's answer
                }
                return item;
              })
              this.cdr.detectChanges(); 
            }
            if (res.message) {
              this.toastr.error(this.translate.transform('Translation failed: ' + res.message));
            }
            if (res?.error?.errors) {
              for (const el in res.error.errors) {
                this.toastr.error(this.translate.transform(res.error.errors[el]));
              }
            }
            else if (res.errors) {
              // Iterate through each error key (e.g., subcategoryname)
              Object.keys(res.errors).forEach(key => {
                // If there are errors for that key, display them
                res.errors[key].forEach((error: string) => {
                  this.toastr.error(this.translate.transform(error));
                });
              });
            }
          },
      }
      );
    }
  }
}
