import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, Router, RouterLink } from '@angular/router';
import { takeUntil } from 'rxjs';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { Unsub } from '../../../shared/class/unsub.class';
import { GuestService } from '../../../shared/services/guest.service';
import { LoaderService } from '../../../shared/services/loader.service';

import { SharedModule } from '../../../shared/shared.module';
import { TranslatePipes } from '../../../shared/pipes/translate/translate.pipe';
@Component({
  selector: 'app-pages',
  templateUrl: './pages.component.html',
  styleUrls: ['./pages.component.scss'],
  standalone : true,
  imports: [TranslatePipes, RouterLink]
})
export class PagesComponent extends Unsub implements OnInit {
  pages;
  id;
  constructor(
    private guestService: GuestService,
    private activedRoute: ActivatedRoute,
    private router: Router,
    loaderService: LoaderService,  private sanitizer: DomSanitizer
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.activedRoute.paramMap.pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (params) => {
        this.id = params.get('id');
        this.pagesFn();
      },
    });
  }

  ngOnInit(): void { }

  pagesFn() {
    this.loaderService.showLoader();
    this.guestService
      .pages(this.id)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          if (res == null) {
            this.router.navigate(['/']);
          }
          this.pages = res;
          this.loaderService.hideLoader();
        },
        error: () => this.loaderService.hideLoader()
      });
  }

  sanitizeHtml(html: string): SafeHtml {
    return this.sanitizer.bypassSecurityTrustHtml(html);
  }
}
