import { CommonModule } from '@angular/common';
import { Component, inject, Input, SimpleChanges } from '@angular/core';
import { ControlContainer, FormControl, FormGroup, ReactiveFormsModule, Validators } from '@angular/forms';
import { NgSelectModule } from '@ng-select/ng-select';
import { TranslatePipes } from '../../../../shared/pipes/translate/translate.pipe';

@Component({
  selector: 'app-ng-select-input',
  standalone: true,
  imports: [ReactiveFormsModule, CommonModule, TranslatePipes, NgSelectModule],
  viewProviders:[
    {
      provide: ControlContainer,
      useFactory : ()=>inject(ControlContainer, { skipSelf : true })
    }
  ],
  template: `<ng-select  [formControlName]="nameField" [items]="tagslist" [loading]="!tagslist" [ngClass]="classText" [id]="idField ? idField : nameField" [placeholder]="'Tags' | translate" [addTag]="addTag ? addTagFn : false" [hideSelected]="hideSelected" [multiple]="multiple" [bindLabel]="bindLabel" [bindValue]="bindValue" [clearable]="false" [maxSelectedItems]="10"> 
   <!-- Show "No items" if tagslist is empty -->
  <ng-template ng-select-empty-list>
    <div>{{'No items' | translate}}</div>
  </ng-template>
  </ng-select>
  <div *ngIf="formControl?.invalid && formControl?.touched" class="error-invalid">
    <span class="text-danger" *ngIf="formControl.hasError('required')">{{'This field is required' | translate}}</span>
  </div>`
})
export class NgSelectInputComponent {
  @Input() nameField!: string;
  @Input() tagslist!: any[];
  @Input() idField!: string;
  @Input() classText!: string;
  @Input() initailSelect!: any;
  @Input() placeholder!: string;
  @Input() bindValue!: string;
  @Input() bindLabel!: string;
  @Input() isRequired!: boolean;
  @Input() isOpen!: boolean;
  @Input() multiple!: boolean;
  @Input() addTag!: boolean;
  @Input() hideSelected!: boolean;
  parentContainer = inject(ControlContainer);

  get parentFormGroup(){
    return this.parentContainer.control as FormGroup;
  }
  get formControl(): FormControl {
    return this.parentFormGroup.get(this.nameField) as FormControl;
  }


  ngOnInit() {
    this.parentFormGroup.addControl(this.nameField, new FormControl(this.initailSelect ?? '', this.isRequired ? Validators.required : null))
  }

  
  addTagFn(name: any) {
    return name;
  }

  
  ngOnChanges(changes: SimpleChanges): void {
    // Check if the initialSelect input has changed
    if (changes['initailSelect']) {
      // Update the form control value
      this.updateFormControl();
    }
  }

  private updateFormControl(): void {
    if (this.parentFormGroup) {
      // Update the value of the form control
      const control = this.parentFormGroup.get(this.nameField);
      if (control) {
        control.setValue(this.initailSelect ?? '');
        control.setValidators(this.isRequired ? Validators.required : null);
        control.updateValueAndValidity();
      } 
    }
  }

  ngOnDestroy() {
    this.parentFormGroup.removeControl(this.nameField);
  }
}
