import { Component, Input, OnInit } from '@angular/core';
import { Unsub } from '../../class/unsub.class';
import { LoaderService } from '../../services/loader.service';
import { TranslatePipes } from '../../pipes/translate/translate.pipe';
import { CommonModule } from '@angular/common';
import { TimeconvertionPipe } from '../../pipes/timeconvertion/timeconvertion.pipe';

@Component({
  selector: 'app-business-hour-card-list',
  standalone: true,
  imports:[TranslatePipes, CommonModule, TimeconvertionPipe],
  templateUrl: './business-hour-card-list.component.html',
  styleUrls: ['./business-hour-card-list.component.scss'],
})
export class BusinessHourCardListComponent extends Unsub implements OnInit {
  @Input('setting') setting: any;
  @Input('businesshours') businesshours: any;
  today = new Date();
  timezone: any;
  constructor(
    loaderService: LoaderService) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    
  }
  
  ngOnInit(): void { }

  
}
