import { Component, OnInit } from '@angular/core';
import { takeUntil } from 'rxjs';
import { Unsub } from '../../class/unsub.class';
import { AdminService } from '../../services/admin/admin.service';
import { CustomersService } from '../../services/customers/customers.service';
import { LoaderService } from '../../services/loader.service';
import { TranslatePipes } from '../../pipes/translate/translate.pipe';
import { CommonModule } from '@angular/common';
import { BusinessHourCardListComponent } from '../business-hour-card-list/business-hour-card-list.component';

@Component({
  selector: 'app-business-hour-card',
  standalone: true,
  imports:[TranslatePipes, CommonModule, BusinessHourCardListComponent],
  templateUrl: './business-hour-card.component.html',
  styleUrls: ['./business-hour-card.component.scss'],
})
export class BusinessHourCardComponent extends Unsub implements OnInit {
  setting: any;
  businesshours: any;
  toggleStatus = false;
  today = new Date();
  timezone: any;
  timestart;
  isonline: any;
  supporticonimageprev: string | null = null;;
  constructor(private customerService: CustomersService, private adminService: AdminService,
    loaderService: LoaderService) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.business();
    this.adminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        this.business();
      }
    });
  }
  business() {
    
    this.loaderService.showLoader();
    this.customerService.checkBusinessHours().pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (res: any) => {
        this.supporticonimageprev = res.supporticonimageprev;
        this.setting = res.setting?.original;
        this.isonline = res.isOnline;
        this.businesshours = res.businesshours;
        this.timezone = this.setting?.default_timezone;
        
        this.toggleStatus = this.businesshours?.some(e => e.weeks)

        this.loaderService.hideLoader();
      },
      error: () => this.loaderService.hideLoader()
    });
  }
  ngOnInit(): void { }
  isOpen = false;
  toggleBusiness() {
    this.isOpen = !this.isOpen;
  }
}
