import { Component, OnInit, Input, ChangeDetectionStrategy } from '@angular/core';
import { GuestService } from '../../services/guest.service';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';

@Component({
  selector: 'app-footer',
  templateUrl: './footer.component.html',
  styleUrls: ['./footer.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush
})
export class FooterComponent implements OnInit {
  @Input() profileData: any;
  constructor(public guestService: GuestService,  private sanitizer: DomSanitizer) {
  }

  ngOnInit(): void {
  }

  sanitizeHtml(html: string): SafeHtml {
    return this.sanitizer.bypassSecurityTrustHtml(html);
  }
}
