import { Component, Input, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { ToastrService } from 'ngx-toastr';
import { Observable, concatMap, interval, takeUntil } from 'rxjs';
import { LocationStrategy } from '@angular/common';
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { TranslatePipe, TranslateService } from '@ngx-translate/core';
import { Unsub } from '../../../class/unsub.class';
import { LanguagesService } from '../../../services/admin/languages.service';
import { LoaderService } from '../../../services/loader.service';
import { AdminService } from '../../../services/admin/admin.service';
@Component({
  selector: 'app-admin-header',
  templateUrl: './admin-header.component.html',
  styleUrls: ['./admin-header.component.scss'],
})
export class AdminHeaderComponent extends Unsub implements OnInit {
  @Input() profileData: any;

  public languageDetails: any;
  public DropDownName: any;
  public Notificationlength: any;
  public notifications: any;
  public allNotificationList: any;
  public notifyList: any;
  public sendingResponse: { [key: string]: boolean } = {};
  permission: any;

  constructor(
    private languagesService: LanguagesService,
    private AdminService: AdminService,
    private toastr: ToastrService,
    private router: Router,
    private locationStrategy: LocationStrategy,
    private translate: TranslatePipe,
    private translateservice: TranslateService,
      private sanitizer: DomSanitizer,
    loaderService: LoaderService
  ) {
    /**
    * This code calls the constructor of the parent class in a subclass. 
    * The super() function is used to initialize the parent class and allows access to its properties and methods. 
    * By calling  super(), the subclass can inherit and use the functionality of the parent class.
    **/
    super(loaderService);
    this.lang();
    this.AdminService.RefreshRquestAdmin$.pipe(
      takeUntil(this.unSubscribe$)
    ).subscribe({
      next: () => {
        this.lang();
      },
    });

  }
  lastPollTime = 0;
  ngOnInit(): void {
    this.AdminService.notificationsreading().pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (res) => {
        this.notifications = res?.notifys?.data;
        if (this.Notificationlength != undefined) {
          if (this.Notificationlength < res?.badgecount) {
            this.toastr.success(this.translate.transform('You received a notification'));
            navigator.vibrate([200, 100, 250]);
            this.playAudio();
          }
        }
        this.Notificationlength = res?.badgecount;
      },
    });
    interval(5000).pipe(
      concatMap(() => {
        const currentTime = Date.now();
        if (this.lastPollTime + 1000 <= currentTime) {
          this.lastPollTime += 1000;
          return this.AdminService.notificationsreading();
        } else {
          return new Observable<void>((observer) => {
            observer.complete();
          });
        }
      })
    ).pipe(takeUntil(this.unSubscribe$)).subscribe({
      next: (res) => {
        this.notifications = res?.notifys?.data;
        if (this.Notificationlength != undefined) {
          if (this.Notificationlength < res?.badgecount) {
            this.toastr.success(this.translate.transform('You received a notification'));
            navigator.vibrate([200, 100, 250]);
            this.playAudio();
          }
        }
        this.Notificationlength = res?.badgecount;
      },
    });
  }

  lang() {
    this.languagesService
      .defaultlang()
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.permission = res.permissions;

          this.languageDetails = res?.languages;
          this.DropDownName = localStorage.getItem('lang');
          if (this.DropDownName != null) {
            this.translateservice.use(this.DropDownName);
          } else {
            res?.languages.map((ele: any) => {
              if (ele.languagecode == res.default_lang) {
                this.DropDownName = ele.languagename;
                this.translateservice.use(ele.languagecode);
              }
            });
          }
        },
      });
  }

  playAudio() {
    const audio = new Audio();
    audio.src = './assets/music/sound.mp3';
    audio.load();
    audio.play();
  }

  setLanCod(cod: any) {
    this.translateservice.use(cod);
    this.DropDownName = cod;
    localStorage.setItem('lang', cod);
    this.AdminService.RefreshRquestAdmin$.next();
  }

  MarkAllRead() {
    const data = {

    };
    this.AdminService.markallnotify(data).pipe(takeUntil(this.unSubscribe$)).subscribe();
  }

  Adminlogout(buttonId) {
    this.sendingResponse[buttonId] = true;
    const data = {

    };
    this.AdminService.AdminLogout(data)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe({
        next: (res) => {
          this.sendingResponse[buttonId] = false;
          localStorage.clear();
          this.toastr.success(this.translate.transform(res.success));
          this.router.navigate(['/admin/login']).then(() => {
          });

          history.pushState(null, '');
          this.locationStrategy.onPopState(() => {
            history.go(1);
          });
        },
        error: () => {
           this.sendingResponse[buttonId] = false;
        },
      });
  }

  toggleSidebar() {
    // app sidebar-mini sidenav-toggled
    document.querySelector('body')?.classList.add('app', 'sidebar-mini');
    document.querySelector('body')?.classList.toggle('sidenav-toggled');
  }

  MarkAsReadWithID(id: any) {
    const data = {

      id: id,
    };

    this.AdminService.markNotification(data)
      .pipe(takeUntil(this.unSubscribe$))
      .subscribe();
  }
  sanitizeHtml(html: string): SafeHtml {
    return this.sanitizer.bypassSecurityTrustHtml(html);
  }
}
