import { Component } from '@angular/core';
import { GuestService } from '../../services/guest.service';
import { ActivatedRoute } from '@angular/router';
import { combineLatest, takeUntil } from 'rxjs';
import { LoaderService } from '../../services/loader.service';
import { Unsub } from '../../class/unsub.class';

@Component({
  selector: 'app-imageview',
  template: ``,
  styleUrls: ['./imageview.component.scss']
})
export class ImageviewComponent extends Unsub{
  imageSrc!: string;
  href;
  base;
  id = '';
  image = '';
  constructor(private activedRoute: ActivatedRoute, loaderService: LoaderService){
    super(loaderService);
    this.href = location.origin;
    this.base = document.querySelector('base')?.getAttribute('href');
    combineLatest([
      this.activedRoute.paramMap,
      this.activedRoute.queryParams
    ]).pipe(takeUntil(this.unSubscribe$)).subscribe(([routeParams, queryParams]) => {
      this.id = routeParams.get('id') || '';
      this.image = queryParams['image'] || '';
      this.viewImage();
    });
    
  }

  viewImage(){
    location.href= `${this.href}${this.base}detail/image/${this.id}/${this.image}`;
  }
}
